/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.holder.PagingPredicateHolder;
import com.hazelcast.client.impl.protocol.task.map.DefaultMapQueryMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.SortingUtil;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import com.hazelcast.query.impl.predicates.PredicateUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMapQueryWithPagingPredicateMessageTask<P>
extends DefaultMapQueryMessageTask<P> {
    private Predicate predicate;

    protected AbstractMapQueryWithPagingPredicateMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object reduce(Collection<QueryResultRow> result2) {
        ArrayList<QueryableEntry> accumulatedList = new ArrayList<QueryableEntry>(result2.size());
        result2.forEach(row -> accumulatedList.add(new CachedQueryEntry(this.serializationService, row.getKey(), row.getValue(), null)));
        PagingPredicateImpl pagingPredicateImpl = this.getPagingPredicate();
        List pageData = SortingUtil.getSortedSubListData(accumulatedList, pagingPredicateImpl);
        return new AbstractMap.SimpleImmutableEntry(this.getPagingPredicate().getAnchorList(), pageData);
    }

    @Override
    protected Predicate getPredicate() {
        if (this.predicate == null) {
            this.predicate = this.getPagingPredicateHolder().asPredicate(this.serializationService);
        }
        return this.predicate;
    }

    protected PagingPredicateImpl getPagingPredicate() {
        return PredicateUtils.unwrapPagingPredicate(this.getPredicate());
    }

    protected abstract PagingPredicateHolder getPagingPredicateHolder();
}

