/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.CompactUtil;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.OffsetReader;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompactInternalGenericRecord
extends CompactGenericRecord
implements InternalGenericRecord {
    private final OffsetReader offsetReader;
    private final Schema schema;
    private final BufferObjectDataInput in;
    private final int dataStartPosition;
    private final int variableOffsetsPosition;
    private final CompactStreamSerializer serializer;
    private final boolean schemaIncludedInBinary;
    @Nullable
    private final Class associatedClass;

    public CompactInternalGenericRecord(CompactStreamSerializer serializer, BufferObjectDataInput in, Schema schema, @Nullable Class associatedClass, boolean schemaIncludedInBinary) {
        this.in = in;
        this.serializer = serializer;
        this.schema = schema;
        this.associatedClass = associatedClass;
        this.schemaIncludedInBinary = schemaIncludedInBinary;
        try {
            int finalPosition;
            int numberOfVariableLengthFields = schema.getNumberOfVariableSizeFields();
            if (numberOfVariableLengthFields != 0) {
                int dataLength = in.readInt();
                this.dataStartPosition = in.position();
                this.variableOffsetsPosition = this.dataStartPosition + dataLength;
                if (dataLength < 255) {
                    this.offsetReader = OffsetReader.BYTE_OFFSET_READER;
                    finalPosition = this.variableOffsetsPosition + numberOfVariableLengthFields;
                } else if (dataLength < 65535) {
                    this.offsetReader = OffsetReader.SHORT_OFFSET_READER;
                    finalPosition = this.variableOffsetsPosition + numberOfVariableLengthFields * 2;
                } else {
                    this.offsetReader = OffsetReader.INT_OFFSET_READER;
                    finalPosition = this.variableOffsetsPosition + numberOfVariableLengthFields * 4;
                }
            } else {
                this.offsetReader = OffsetReader.INT_OFFSET_READER;
                this.variableOffsetsPosition = 0;
                this.dataStartPosition = in.position();
                finalPosition = this.dataStartPosition + schema.getFixedSizeFieldsLength();
            }
            in.position(finalPosition);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Nullable
    public Class getAssociatedClass() {
        return this.associatedClass;
    }

    public BufferObjectDataInput getIn() {
        return this.in;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilder() {
        return this.serializer.createGenericRecordBuilder(this.schema);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder cloneWithBuilder() {
        return this.serializer.createGenericRecordCloner(this.schema, this);
    }

    @Override
    @Nonnull
    public FieldKind getFieldKind(@Nonnull String fieldName) {
        FieldDescriptor field2 = this.schema.getField(fieldName);
        if (field2 == null) {
            throw new IllegalArgumentException("Field name " + fieldName + " does not exist in the schema");
        }
        return field2.getKind();
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.schema.hasField(fieldName);
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.schema.getFieldNames();
    }

    @Override
    public boolean getBoolean(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case BOOLEAN: {
                return this.getBoolean(fd);
            }
            case NULLABLE_BOOLEAN: {
                return this.getVariableSizeAsNonNull(fd, DataInput::readBoolean, "Boolean");
            }
        }
        throw this.unexpectedFieldKind(FieldKind.BOOLEAN, fieldName);
    }

    private boolean getBoolean(FieldDescriptor fd) {
        try {
            int booleanOffset = fd.getOffset();
            byte bitOffset = fd.getBitOffset();
            int getOffset = booleanOffset + this.dataStartPosition;
            byte lastByte = this.in.readByte(getOffset);
            return (lastByte >>> bitOffset & 1) != 0;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public byte getInt8(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case INT8: {
                try {
                    return this.in.readByte(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_INT8: {
                return this.getVariableSizeAsNonNull(fd, DataInput::readByte, "Int8");
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    public short getInt16(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case INT16: {
                try {
                    return this.in.readShort(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_INT16: {
                return this.getVariableSizeAsNonNull(fd, DataInput::readShort, "Int16");
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    public int getInt32(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case INT32: {
                try {
                    return this.in.readInt(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_INT32: {
                return this.getVariableSizeAsNonNull(fd, DataInput::readInt, "Int32");
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    public long getInt64(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case INT64: {
                try {
                    return this.in.readLong(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_INT64: {
                return this.getVariableSizeAsNonNull(fd, DataInput::readLong, "Int64");
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    public float getFloat32(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case FLOAT32: {
                try {
                    return this.in.readFloat(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_FLOAT32: {
                return this.getVariableSizeAsNonNull(fd, DataInput::readFloat, "Float32").floatValue();
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    public double getFloat64(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case FLOAT64: {
                try {
                    return this.in.readDouble(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_FLOAT64: {
                return this.getVariableSizeAsNonNull(fd, DataInput::readDouble, "Float64");
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    public char getChar(@Nonnull String fieldName) {
        throw new UnsupportedOperationException("Compact format does not support reading a char field");
    }

    @Override
    public String getString(@Nonnull String fieldName) {
        return this.getVariableSize(fieldName, FieldKind.STRING, ObjectDataInput::readString);
    }

    private <T> T getVariableSize(FieldDescriptor fieldDescriptor, Reader<T> reader) {
        int currentPos = this.in.position();
        try {
            int pos = this.readVariableSizeFieldPosition(fieldDescriptor);
            if (pos == -1) {
                T t = null;
                return t;
            }
            this.in.position(pos);
            T t = reader.read(this.in);
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private <T> T getVariableSizeAsNonNull(FieldDescriptor fieldDescriptor, Reader<T> reader, String methodSuffix) {
        T value = this.getVariableSize(fieldDescriptor, reader);
        if (value == null) {
            throw CompactUtil.exceptionForUnexpectedNullValue(fieldDescriptor.getFieldName(), methodSuffix);
        }
        return value;
    }

    private <T> T getVariableSize(@Nonnull String fieldName, FieldKind fieldKind, Reader<T> reader) {
        int currentPos = this.in.position();
        try {
            int pos = this.readVariableSizeFieldPosition(fieldName, fieldKind);
            if (pos == -1) {
                T t = null;
                return t;
            }
            this.in.position(pos);
            T t = reader.read(this.in);
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public BigDecimal getDecimal(@Nonnull String fieldName) {
        return this.getVariableSize(fieldName, FieldKind.DECIMAL, IOUtil::readBigDecimal);
    }

    @Override
    @Nullable
    public LocalTime getTime(@Nonnull String fieldName) {
        return this.getVariableSize(fieldName, FieldKind.TIME, IOUtil::readLocalTime);
    }

    @Override
    @Nullable
    public LocalDate getDate(@Nonnull String fieldName) {
        return this.getVariableSize(fieldName, FieldKind.DATE, IOUtil::readLocalDate);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestamp(@Nonnull String fieldName) {
        return this.getVariableSize(fieldName, FieldKind.TIMESTAMP, IOUtil::readLocalDateTime);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezone(@Nonnull String fieldName) {
        return this.getVariableSize(fieldName, FieldKind.TIMESTAMP_WITH_TIMEZONE, IOUtil::readOffsetDateTime);
    }

    @Override
    @Nullable
    public GenericRecord getGenericRecord(@Nonnull String fieldName) {
        return this.getVariableSize(fieldName, FieldKind.COMPACT, in -> this.serializer.readGenericRecord(in, this.schemaIncludedInBinary));
    }

    @Override
    @Nullable
    public <T> T getObject(@Nonnull String fieldName) {
        return (T)this.getVariableSize(fieldName, FieldKind.COMPACT, in -> this.serializer.read(in, this.schemaIncludedInBinary));
    }

    @Override
    @Nullable
    public boolean[] getArrayOfBoolean(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case ARRAY_OF_BOOLEAN: {
                return this.getVariableSize(fd, CompactInternalGenericRecord::readBooleanBits);
            }
            case ARRAY_OF_NULLABLE_BOOLEAN: {
                return this.getNullableArrayAsPrimitiveArray(fd, ObjectDataInput::readBooleanArray, "Boolean");
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public byte[] getArrayOfInt8(@Nonnull String fieldName) {
        return this.getArrayOfPrimitive(fieldName, ObjectDataInput::readByteArray, FieldKind.ARRAY_OF_INT8, FieldKind.ARRAY_OF_NULLABLE_INT8, "Int8");
    }

    @Override
    @Nullable
    public char[] getArrayOfChar(@Nonnull String fieldName) {
        throw new UnsupportedOperationException("Compact format does not support reading an array of chars field");
    }

    @Override
    @Nullable
    public short[] getArrayOfInt16(@Nonnull String fieldName) {
        return this.getArrayOfPrimitive(fieldName, ObjectDataInput::readShortArray, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16, "Int16");
    }

    @Override
    @Nullable
    public int[] getArrayOfInt32(@Nonnull String fieldName) {
        return this.getArrayOfPrimitive(fieldName, ObjectDataInput::readIntArray, FieldKind.ARRAY_OF_INT32, FieldKind.ARRAY_OF_NULLABLE_INT32, "Int32");
    }

    @Override
    @Nullable
    public long[] getArrayOfInt64(@Nonnull String fieldName) {
        return this.getArrayOfPrimitive(fieldName, ObjectDataInput::readLongArray, FieldKind.ARRAY_OF_INT64, FieldKind.ARRAY_OF_NULLABLE_INT64, "Int64");
    }

    @Override
    @Nullable
    public float[] getArrayOfFloat32(@Nonnull String fieldName) {
        return this.getArrayOfPrimitive(fieldName, ObjectDataInput::readFloatArray, FieldKind.ARRAY_OF_FLOAT32, FieldKind.ARRAY_OF_NULLABLE_FLOAT32, "Float32");
    }

    @Override
    @Nullable
    public double[] getArrayOfFloat64(@Nonnull String fieldName) {
        return this.getArrayOfPrimitive(fieldName, ObjectDataInput::readDoubleArray, FieldKind.ARRAY_OF_FLOAT64, FieldKind.ARRAY_OF_NULLABLE_FLOAT64, "Float64");
    }

    @Override
    @Nullable
    public String[] getArrayOfString(@Nonnull String fieldName) {
        return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_STRING, String[]::new, ObjectDataInput::readString);
    }

    @Override
    @Nullable
    public BigDecimal[] getArrayOfDecimal(@Nonnull String fieldName) {
        return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_DECIMAL, BigDecimal[]::new, IOUtil::readBigDecimal);
    }

    @Override
    @Nullable
    public LocalTime[] getArrayOfTime(@Nonnull String fieldName) {
        return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_TIME, LocalTime[]::new, IOUtil::readLocalTime);
    }

    @Override
    @Nullable
    public LocalDate[] getArrayOfDate(@Nonnull String fieldName) {
        return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_DATE, LocalDate[]::new, IOUtil::readLocalDate);
    }

    @Override
    @Nullable
    public LocalDateTime[] getArrayOfTimestamp(@Nonnull String fieldName) {
        return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_TIMESTAMP, LocalDateTime[]::new, IOUtil::readLocalDateTime);
    }

    @Override
    @Nullable
    public OffsetDateTime[] getArrayOfTimestampWithTimezone(@Nonnull String fieldName) {
        return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE, OffsetDateTime[]::new, IOUtil::readOffsetDateTime);
    }

    @Override
    @Nullable
    public GenericRecord[] getArrayOfGenericRecord(@Nonnull String fieldName) {
        return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_COMPACT, GenericRecord[]::new, in -> this.serializer.readGenericRecord(in, this.schemaIncludedInBinary));
    }

    private <T> T getArrayOfPrimitive(@Nonnull String fieldName, Reader<T> reader, FieldKind primitiveKind, FieldKind nullableKind, String methodSuffix) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        if (fieldKind == primitiveKind) {
            return this.getVariableSize(fd, reader);
        }
        if (fieldKind == nullableKind) {
            return this.getNullableArrayAsPrimitiveArray(fd, reader, methodSuffix);
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    private <T> T getNullableArrayAsPrimitiveArray(FieldDescriptor fd, Reader<T> reader, String methodSuffix) {
        int currentPos = this.in.position();
        try {
            int position = this.readVariableSizeFieldPosition(fd);
            if (position == -1) {
                T t = null;
                return t;
            }
            this.in.position(position);
            int dataLength = this.in.readInt();
            int itemCount = this.in.readInt();
            int dataStartPosition = this.in.position();
            OffsetReader offsetReader = CompactInternalGenericRecord.getOffsetReader(dataLength);
            int offsetsPosition = dataStartPosition + dataLength;
            for (int i = 0; i < itemCount; ++i) {
                int offset = offsetReader.getOffset(this.in, offsetsPosition, i);
                if (offset != -1) continue;
                throw CompactUtil.exceptionForUnexpectedNullValueInArray(fd.getFieldName(), methodSuffix);
            }
            this.in.position(dataStartPosition - 4);
            T t = reader.read(this.in);
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    @Nullable
    public Boolean getNullableBoolean(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case BOOLEAN: {
                return this.getBoolean(fd);
            }
            case NULLABLE_BOOLEAN: {
                return this.getVariableSize(fd, DataInput::readBoolean);
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public Byte getNullableInt8(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case INT8: {
                try {
                    return this.in.readByte(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_INT8: {
                return this.getVariableSize(fd, DataInput::readByte);
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public Short getNullableInt16(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case INT16: {
                try {
                    return this.in.readShort(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_INT16: {
                return this.getVariableSize(fd, DataInput::readShort);
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public Integer getNullableInt32(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case INT32: {
                try {
                    return this.in.readInt(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_INT32: {
                return this.getVariableSize(fd, DataInput::readInt);
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public Long getNullableInt64(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case INT64: {
                try {
                    return this.in.readLong(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_INT64: {
                return this.getVariableSize(fd, DataInput::readLong);
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public Float getNullableFloat32(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case FLOAT32: {
                try {
                    return Float.valueOf(this.in.readFloat(this.readFixedSizePosition(fd)));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_FLOAT32: {
                return this.getVariableSize(fd, DataInput::readFloat);
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public Double getNullableFloat64(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case FLOAT64: {
                try {
                    return this.in.readDouble(this.readFixedSizePosition(fd));
                }
                catch (IOException e) {
                    throw this.illegalStateException(e);
                }
            }
            case NULLABLE_FLOAT64: {
                return this.getVariableSize(fd, DataInput::readDouble);
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public Boolean[] getArrayOfNullableBoolean(@Nonnull String fieldName) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        switch (fieldKind) {
            case ARRAY_OF_BOOLEAN: {
                return this.getVariableSize(fieldName, FieldKind.ARRAY_OF_BOOLEAN, CompactInternalGenericRecord::readBooleanBitsAsNullables);
            }
            case ARRAY_OF_NULLABLE_BOOLEAN: {
                return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN, Boolean[]::new, DataInput::readBoolean);
            }
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    @Nullable
    public Byte[] getArrayOfNullableInt8(@Nonnull String fieldName) {
        return this.getArrayOfNullable(fieldName, DataInput::readByte, Byte[]::new, FieldKind.ARRAY_OF_INT8, FieldKind.ARRAY_OF_NULLABLE_INT8);
    }

    @Override
    @Nullable
    public Short[] getArrayOfNullableInt16(@Nonnull String fieldName) {
        return this.getArrayOfNullable(fieldName, DataInput::readShort, Short[]::new, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16);
    }

    @Override
    @Nullable
    public Integer[] getArrayOfNullableInt32(@Nonnull String fieldName) {
        return this.getArrayOfNullable(fieldName, DataInput::readInt, Integer[]::new, FieldKind.ARRAY_OF_INT32, FieldKind.ARRAY_OF_NULLABLE_INT32);
    }

    @Override
    @Nullable
    public Long[] getArrayOfNullableInt64(@Nonnull String fieldName) {
        return this.getArrayOfNullable(fieldName, DataInput::readLong, Long[]::new, FieldKind.ARRAY_OF_INT64, FieldKind.ARRAY_OF_NULLABLE_INT64);
    }

    @Override
    @Nullable
    public Float[] getArrayOfNullableFloat32(@Nonnull String fieldName) {
        return this.getArrayOfNullable(fieldName, DataInput::readFloat, Float[]::new, FieldKind.ARRAY_OF_FLOAT32, FieldKind.ARRAY_OF_NULLABLE_FLOAT32);
    }

    @Override
    @Nullable
    public Double[] getArrayOfNullableFloat64(@Nonnull String fieldName) {
        return this.getArrayOfNullable(fieldName, DataInput::readDouble, Double[]::new, FieldKind.ARRAY_OF_FLOAT64, FieldKind.ARRAY_OF_NULLABLE_FLOAT64);
    }

    private <T> T[] getArrayOfNullable(@Nonnull String fieldName, Reader<T> reader, Function<Integer, T[]> constructor, FieldKind primitiveKind, FieldKind nullableKind) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        FieldKind fieldKind = fd.getKind();
        if (fieldKind == primitiveKind) {
            return this.getPrimitiveArrayAsNullableArray(fd, constructor, reader);
        }
        if (fieldKind == nullableKind) {
            return this.getArrayOfVariableSize(fd, constructor, reader);
        }
        throw this.unexpectedFieldKind(fieldKind, fieldName);
    }

    @Override
    public <T> T[] getArrayOfObject(@Nonnull String fieldName, Class<T> componentType) {
        return this.getArrayOfVariableSize(fieldName, FieldKind.ARRAY_OF_COMPACT, length -> (Object[])Array.newInstance(componentType, (int)length), in -> this.serializer.read(in, this.schemaIncludedInBinary));
    }

    private <T> T[] getPrimitiveArrayAsNullableArray(FieldDescriptor fieldDescriptor, Function<Integer, T[]> constructor, Reader<T> reader) {
        int currentPos = this.in.position();
        try {
            int pos = this.readVariableSizeFieldPosition(fieldDescriptor);
            if (pos == -1) {
                T[] TArray = null;
                return TArray;
            }
            this.in.position(pos);
            int itemCount = this.in.readInt();
            T[] values = constructor.apply(itemCount);
            for (int i = 0; i < itemCount; ++i) {
                values[i] = reader.read(this.in);
            }
            T[] TArray = values;
            return TArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private <T> T[] getArrayOfVariableSize(FieldDescriptor fieldDescriptor, Function<Integer, T[]> constructor, Reader<T> reader) {
        int currentPos = this.in.position();
        try {
            int position = this.readVariableSizeFieldPosition(fieldDescriptor);
            if (position == -1) {
                T[] TArray = null;
                return TArray;
            }
            this.in.position(position);
            int dataLength = this.in.readInt();
            int itemCount = this.in.readInt();
            int dataStartPosition = this.in.position();
            T[] values = constructor.apply(itemCount);
            OffsetReader offsetReader = CompactInternalGenericRecord.getOffsetReader(dataLength);
            int offsetsPosition = dataStartPosition + dataLength;
            for (int i = 0; i < itemCount; ++i) {
                int offset = offsetReader.getOffset(this.in, offsetsPosition, i);
                if (offset == -1) continue;
                this.in.position(offset + dataStartPosition);
                values[i] = reader.read(this.in);
            }
            T[] TArray = values;
            return TArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private <T> T[] getArrayOfVariableSize(@Nonnull String fieldName, FieldKind fieldKind, Function<Integer, T[]> constructor, Reader<T> reader) {
        FieldDescriptor fieldDefinition = this.getFieldDefinition(fieldName, fieldKind);
        return this.getArrayOfVariableSize(fieldDefinition, constructor, reader);
    }

    private static OffsetReader getOffsetReader(int dataLength) {
        if (dataLength < 255) {
            return OffsetReader.BYTE_OFFSET_READER;
        }
        if (dataLength < 65535) {
            return OffsetReader.SHORT_OFFSET_READER;
        }
        return OffsetReader.INT_OFFSET_READER;
    }

    private int readFixedSizePosition(FieldDescriptor fd) {
        int primitiveOffset = fd.getOffset();
        return primitiveOffset + this.dataStartPosition;
    }

    @Nonnull
    private FieldDescriptor getFieldDefinition(@Nonnull String fieldName) {
        FieldDescriptor fd = this.schema.getField(fieldName);
        if (fd == null) {
            throw this.throwUnknownFieldException(fieldName);
        }
        return fd;
    }

    @Nonnull
    private FieldDescriptor getFieldDefinition(@Nonnull String fieldName, FieldKind fieldKind) {
        FieldDescriptor fd = this.getFieldDefinition(fieldName);
        if (fd.getKind() != fieldKind) {
            throw this.unexpectedFieldKind(fd.getKind(), fieldName);
        }
        return fd;
    }

    private int readVariableSizeFieldPosition(@Nonnull String fieldName, FieldKind fieldKind) {
        try {
            FieldDescriptor fd = this.getFieldDefinition(fieldName, fieldKind);
            int index = fd.getIndex();
            int offset = this.offsetReader.getOffset(this.in, this.variableOffsetsPosition, index);
            return offset == -1 ? -1 : offset + this.dataStartPosition;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    private int readVariableSizeFieldPosition(FieldDescriptor fd) {
        try {
            int index = fd.getIndex();
            int offset = this.offsetReader.getOffset(this.in, this.variableOffsetsPosition, index);
            return offset == -1 ? -1 : offset + this.dataStartPosition;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    private HazelcastSerializationException throwUnknownFieldException(@Nonnull String fieldName) {
        return new HazelcastSerializationException("Unknown field name: '" + fieldName + "' for " + this.schema);
    }

    private int readLength(int beginPosition) {
        try {
            return this.in.readInt(beginPosition);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Byte getInt8FromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldKind.ARRAY_OF_INT8, DataInput::readByte, index);
    }

    @Override
    public Boolean getBooleanFromArray(@Nonnull String fieldName, int index) {
        int position = this.readVariableSizeFieldPosition(fieldName, FieldKind.ARRAY_OF_BOOLEAN);
        if (position == -1) {
            return null;
        }
        if (this.readLength(position) <= index) {
            return null;
        }
        int currentPos = this.in.position();
        try {
            int booleanOffsetInBytes = index / 8;
            int booleanOffsetWithinLastByte = index % 8;
            byte b = this.in.readByte(4 + position + booleanOffsetInBytes);
            Boolean bl = (b >>> booleanOffsetWithinLastByte & 1) != 0;
            return bl;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public Character getCharFromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException("Compact format does not support reading from an array of chars field");
    }

    @Override
    public Integer getInt32FromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldKind.ARRAY_OF_INT32, DataInput::readInt, index);
    }

    @Override
    public Long getInt64FromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldKind.ARRAY_OF_INT64, DataInput::readLong, index);
    }

    @Override
    public Double getFloat64FromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldKind.ARRAY_OF_FLOAT64, DataInput::readDouble, index);
    }

    @Override
    public Float getFloat32FromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldKind.ARRAY_OF_FLOAT32, DataInput::readFloat, index);
    }

    @Override
    public Short getInt16FromArray(@Nonnull String fieldName, int index) {
        return this.getFixedSizeFieldFromArray(fieldName, FieldKind.ARRAY_OF_INT16, DataInput::readShort, index);
    }

    private <T> T getFixedSizeFieldFromArray(@Nonnull String fieldName, FieldKind fieldKind, Reader<T> reader, int index) {
        Preconditions.checkNotNegative(index, "Array indexes can not be negative");
        int position = this.readVariableSizeFieldPosition(fieldName, fieldKind);
        if (position == -1) {
            return null;
        }
        if (this.readLength(position) <= index) {
            return null;
        }
        int currentPos = this.in.position();
        try {
            FieldKind singleKind = FieldOperations.getSingleKind(fieldKind);
            int kindSize = FieldOperations.fieldOperations(singleKind).kindSizeInBytes();
            this.in.position(4 + position + index * kindSize);
            T t = reader.read(this.in);
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public String getStringFromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_STRING, ObjectDataInput::readString, index);
    }

    @Override
    public GenericRecord getGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_COMPACT, in -> this.serializer.readGenericRecord(in, this.schemaIncludedInBinary), index);
    }

    @Override
    public BigDecimal getDecimalFromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_DECIMAL, IOUtil::readBigDecimal, index);
    }

    @Override
    @Nullable
    public LocalTime getTimeFromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_TIME, IOUtil::readLocalTime, index);
    }

    @Override
    @Nullable
    public LocalDate getDateFromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_DATE, IOUtil::readLocalDate, index);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestampFromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_TIMESTAMP, IOUtil::readLocalDateTime, index);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezoneFromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE, IOUtil::readOffsetDateTime, index);
    }

    @Override
    @Nullable
    public Byte getNullableInt8FromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT8, DataInput::readByte, index);
    }

    @Override
    @Nullable
    public Boolean getNullableBooleanFromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN, DataInput::readBoolean, index);
    }

    @Override
    @Nullable
    public Integer getNullableInt32FromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT32, DataInput::readInt, index);
    }

    @Override
    @Nullable
    public Long getNullableInt64FromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT64, DataInput::readLong, index);
    }

    @Override
    @Nullable
    public Float getNullableFloat32FromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT32, DataInput::readFloat, index);
    }

    @Override
    @Nullable
    public Double getNullableFloat64FromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT64, DataInput::readDouble, index);
    }

    @Override
    @Nullable
    public Short getNullableInt16FromArray(@Nonnull String fieldName, int index) {
        return this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT16, DataInput::readShort, index);
    }

    @Override
    @Nullable
    public <T> T getObjectFromArray(@Nonnull String fieldName, int index) {
        return (T)this.getVariableSizeFromArray(fieldName, FieldKind.ARRAY_OF_COMPACT, in -> this.serializer.read(in, this.schemaIncludedInBinary), index);
    }

    private <T> T getVariableSizeFromArray(@Nonnull String fieldName, FieldKind fieldKind, Reader<T> reader, int index) {
        int currentPos = this.in.position();
        try {
            int offsetsPosition;
            int pos = this.readVariableSizeFieldPosition(fieldName, fieldKind);
            if (pos == -1) {
                T t = null;
                return t;
            }
            int dataLength = this.in.readInt(pos);
            int itemCount = this.in.readInt(pos + 4);
            Preconditions.checkNotNegative(index, "Array index can not be negative");
            if (itemCount <= index) {
                T t = null;
                return t;
            }
            int dataStartPosition = pos + 8;
            OffsetReader offsetReader = CompactInternalGenericRecord.getOffsetReader(dataLength);
            int indexedItemOffset = offsetReader.getOffset(this.in, offsetsPosition = dataStartPosition + dataLength, index);
            if (indexedItemOffset != -1) {
                this.in.position(indexedItemOffset + dataStartPosition);
                T t = reader.read(this.in);
                return t;
            }
            T t = null;
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    protected Object getClassIdentifier() {
        return this.schema.getTypeName();
    }

    protected IllegalStateException illegalStateException(IOException e) {
        return new IllegalStateException("IOException is not expected since we get from a well known format and position", e);
    }

    private HazelcastSerializationException unexpectedFieldKind(FieldKind actualFieldKind, String fieldName) {
        throw new HazelcastSerializationException("Unexpected fieldKind '" + (Object)((Object)actualFieldKind) + "' for field: " + fieldName);
    }

    private static boolean[] readBooleanBits(BufferObjectDataInput input2) throws IOException {
        int len = input2.readInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new boolean[0];
        }
        boolean[] values = new boolean[len];
        int index = 0;
        byte currentByte = input2.readByte();
        for (int i = 0; i < len; ++i) {
            if (index == 8) {
                index = 0;
                currentByte = input2.readByte();
            }
            boolean result2 = (currentByte >>> index & 1) != 0;
            ++index;
            values[i] = result2;
        }
        return values;
    }

    private static Boolean[] readBooleanBitsAsNullables(BufferObjectDataInput input2) throws IOException {
        int len = input2.readInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new Boolean[0];
        }
        Boolean[] values = new Boolean[len];
        int index = 0;
        byte currentByte = input2.readByte();
        for (int i = 0; i < len; ++i) {
            if (index == 8) {
                index = 0;
                currentByte = input2.readByte();
            }
            boolean result2 = (currentByte >>> index & 1) != 0;
            ++index;
            values[i] = result2;
        }
        return values;
    }

    boolean isFieldExists(@Nonnull String fieldName, @Nonnull FieldKind kind) {
        FieldDescriptor field2 = this.schema.getField(fieldName);
        if (field2 == null) {
            return false;
        }
        return field2.getKind() == kind;
    }

    protected static interface Reader<R> {
        public R read(BufferObjectDataInput var1) throws IOException;
    }
}

