/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.factory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryException;
import org.apache.seatunnel.api.table.factory.SupportMultipleTable;
import org.apache.seatunnel.api.table.factory.TableFactoryContext;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FactoryUtil.class);

    public static <T, SplitT extends SourceSplit, StateT extends Serializable> List<SeaTunnelSource<T, SplitT, StateT>> createAndPrepareSource(List<CatalogTable> multipleTables, Map<String, String> options, ClassLoader classLoader, String factoryIdentifier) {
        try {
            TableSourceFactory factory = FactoryUtil.discoverFactory(classLoader, TableSourceFactory.class, factoryIdentifier);
            ArrayList<SeaTunnelSource<T, SplitT, StateT>> sources = new ArrayList<SeaTunnelSource<T, SplitT, StateT>>(multipleTables.size());
            if (factory instanceof SupportMultipleTable) {
                TableFactoryContext context = new TableFactoryContext(multipleTables, options, classLoader);
                SupportMultipleTable multipleTableSourceFactory = (SupportMultipleTable)((Object)factory);
                SupportMultipleTable.Result result2 = multipleTableSourceFactory.applyTables(context);
                TableSource multipleTableSource = factory.createSource(new TableFactoryContext(result2.getAcceptedTables(), options, classLoader));
                SeaTunnelSource source = multipleTableSource.createSource();
                sources.add(source);
            }
            return sources;
        }
        catch (Throwable t) {
            throw new FactoryException(String.format("Unable to create a source for identifier '%s'.", factoryIdentifier), t);
        }
    }

    public static <IN, StateT, CommitInfoT, AggregatedCommitInfoT> SeaTunnelSink<IN, StateT, CommitInfoT, AggregatedCommitInfoT> createAndPrepareSink(ClassLoader classLoader, String factoryIdentifier) {
        TableSinkFactory factory = FactoryUtil.discoverFactory(classLoader, TableSinkFactory.class, factoryIdentifier);
        return factory.createSink(null).createSink();
    }

    public static Catalog createCatalog(String catalogName, Map<String, String> options, ClassLoader classLoader, String factoryIdentifier) {
        CatalogFactory catalogFactory = FactoryUtil.discoverFactory(classLoader, CatalogFactory.class, factoryIdentifier);
        return catalogFactory.createCatalog(catalogName, options);
    }

    public static <T extends Factory> T discoverFactory(ClassLoader classLoader, Class<T> factoryClass, String factoryIdentifier) {
        List<Factory> factories = FactoryUtil.discoverFactories(classLoader);
        List foundFactories = factories.stream().filter(f -> factoryClass.isAssignableFrom(f.getClass())).collect(Collectors.toList());
        if (foundFactories.isEmpty()) {
            throw new FactoryException(String.format("Could not find any factories that implement '%s' in the classpath.", factoryClass.getName()));
        }
        List matchingFactories = foundFactories.stream().filter(f -> f.factoryIdentifier().equals(factoryIdentifier)).collect(Collectors.toList());
        if (matchingFactories.isEmpty()) {
            throw new FactoryException(String.format("Could not find any factory for identifier '%s' that implements '%s' in the classpath.\n\nAvailable factory identifiers are:\n\n%s", factoryIdentifier, factoryClass.getName(), foundFactories.stream().map(Factory::factoryIdentifier).distinct().sorted().collect(Collectors.joining("\n"))));
        }
        if (matchingFactories.size() > 1) {
            throw new FactoryException(String.format("Multiple factories for identifier '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", factoryIdentifier, factoryClass.getName(), matchingFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return (T)((Factory)matchingFactories.get(0));
    }

    private static List<Factory> discoverFactories(ClassLoader classLoader) {
        try {
            LinkedList<Factory> result2 = new LinkedList<Factory>();
            ServiceLoader.load(Factory.class, classLoader).iterator().forEachRemaining(result2::add);
            return result2;
        }
        catch (ServiceConfigurationError e) {
            LOG.error("Could not load service provider for factories.", e);
            throw new FactoryException("Could not load service provider for factories.", e);
        }
    }
}

