/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import com.hazelcast.ringbuffer.Ringbuffer;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.flow.AbstractFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class PartitionTransformSinkFlowLifeCycle
extends AbstractFlowLifeCycle
implements OneInputFlowLifeCycle<Record<?>> {
    private Ringbuffer<Record<?>>[] ringbuffers;
    private final Random random = new Random();

    public PartitionTransformSinkFlowLifeCycle(SeaTunnelTask runningTask, CompletableFuture<Void> completableFuture) {
        super(runningTask, completableFuture);
    }

    @Override
    public void received(Record<?> row) throws IOException {
        if (row.getData() instanceof Barrier) {
            Barrier barrier = (Barrier)row.getData();
            this.runningTask.ack(barrier);
            if (barrier.prepareClose()) {
                this.prepareClose = true;
            }
            for (Ringbuffer<Record<?>> ringBuffer : this.ringbuffers) {
                ringBuffer.add(new Record<Barrier>(barrier));
            }
        } else {
            if (this.prepareClose.booleanValue()) {
                return;
            }
            this.getRingBuffer(row).add(row);
        }
    }

    private Ringbuffer<Record<?>> getRingBuffer(Record<?> row) {
        return this.ringbuffers[this.random.nextInt(this.ringbuffers.length)];
    }
}

