/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;

public class RequestSplitOperation
extends Operation
implements IdentifiedDataSerializable {
    private TaskLocation enumeratorTaskID;
    private TaskLocation taskID;

    public RequestSplitOperation() {
    }

    public RequestSplitOperation(TaskLocation taskID, TaskLocation enumeratorTaskID) {
        this.enumeratorTaskID = enumeratorTaskID;
        this.taskID = taskID;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            SourceSplitEnumeratorTask task = (SourceSplitEnumeratorTask)server.getTaskExecutionService().getTask(this.enumeratorTaskID);
            task.requestSplit(this.taskID.getTaskID());
            return null;
        }, new RetryUtils.RetryMaterial(5, true, exception -> exception instanceof NullPointerException && !server.taskIsEnded(this.enumeratorTaskID.getTaskGroupLocation()), 2000L));
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.taskID);
        out.writeObject(this.enumeratorTaskID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskID = (TaskLocation)in.readObject();
        this.enumeratorTaskID = (TaskLocation)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }
}

