/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seatunnel.connectors.seatunnel.http.config;

public enum HttpPaginationType {
    /** Page number based pagination */
    PAGE_NUMBER(
            "PageNumber",
            "traditional page-number-based pagination,uses a page number and page size to retrieve a specific slice of data"),
    /** Cursor based pagination */
    CURSOR(
            "Cursor",
            "token-based cursor pagination,uses a cursor/token to fetch the next set of data based on a specific point or marker");

    private final String code;
    private final String description;

    HttpPaginationType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return code;
    }
}
