/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.impl.KafkaKingbaseDataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class MongoDBDataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private static final Logger log = LoggerFactory.getLogger(MongoDBDataSourceConfigSwitcher.class);
    private static final String DATABASE = "database";
    private static final String COLLECTION = "collection";
    private static final String SCHEMA = "schema";

    @Override
    public String getDataSourceName() {
        return "MONGODB";
    }

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        excludedKeys.add(SCHEMA);
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, excludedKeys);
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        connectorConfig = connectorConfig.withValue(DATABASE, ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(DATABASE)));
        connectorConfig = connectorConfig.withValue(COLLECTION, ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(COLLECTION)));
        if (pluginType == PluginType.SOURCE) {
            connectorConfig = connectorConfig.withValue(SCHEMA, (ConfigValue)KafkaKingbaseDataSourceConfigSwitcher.SchemaGenerator.generateSchemaBySelectTableFields(virtualTableDetail, selectTableFields).root());
        }
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }
}

