/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import java.util.Objects;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.Condition;

public class Expression {
    private final Condition<?> condition;
    private Boolean and = null;
    private Expression next = null;

    Expression(Condition<?> condition) {
        this.condition = condition;
    }

    public static <T> Expression of(Option<T> option, T expectValue) {
        return new Expression(Condition.of(option, expectValue));
    }

    public static Expression of(Condition<?> condition) {
        return new Expression(condition);
    }

    public Expression and(Expression next) {
        this.addExpression(true, next);
        return this;
    }

    public Expression or(Expression next) {
        this.addExpression(false, next);
        return this;
    }

    private void addExpression(boolean and, Expression next) {
        Expression tail = this.getTailExpression();
        tail.and = and;
        tail.next = next;
    }

    private Expression getTailExpression() {
        return this.hasNext() ? this.next.getTailExpression() : this;
    }

    public Condition<?> getCondition() {
        return this.condition;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Expression getNext() {
        return this.next;
    }

    public Boolean and() {
        return this.and;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression that = (Expression)obj;
        return Objects.equals(this.condition, that.condition) && Objects.equals(this.and, that.and) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.and, this.next);
    }

    public String toString() {
        Expression cur = this;
        StringBuilder builder = new StringBuilder();
        boolean bracket = false;
        do {
            if (cur.condition.getCount() > 1) {
                builder.append("(").append(cur.condition).append(")");
            } else {
                builder.append(cur.condition);
            }
            if (bracket) {
                builder = new StringBuilder(String.format("(%s)", builder));
                bracket = false;
            }
            if (!cur.hasNext()) continue;
            if (cur.next.hasNext() && !cur.and.equals(cur.next.and)) {
                bracket = true;
            }
            builder.append(cur.and != false ? " && " : " || ");
        } while ((cur = cur.next) != null);
        return builder.toString();
    }
}

