/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.logging.ILogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.client.SeaTunnelClientInstance;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.client.job.JobClient;
import org.apache.seatunnel.engine.client.job.JobExecutionEnvironment;
import org.apache.seatunnel.engine.client.job.JobMetricsRunner;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetClusterHealthMetricsCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelPrintMessageCodec;

public class SeaTunnelClient
implements SeaTunnelClientInstance {
    private final SeaTunnelHazelcastClient hazelcastClient;
    private final JobClient jobClient;

    public SeaTunnelClient(@NonNull ClientConfig clientConfig) {
        if (clientConfig == null) {
            throw new NullPointerException("clientConfig is marked non-null but is null");
        }
        this.hazelcastClient = new SeaTunnelHazelcastClient(clientConfig);
        this.jobClient = new JobClient(this.hazelcastClient);
    }

    @Override
    public JobExecutionEnvironment createExecutionContext(@NonNull String filePath, @NonNull JobConfig jobConfig) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked non-null but is null");
        }
        return new JobExecutionEnvironment(jobConfig, filePath, this.hazelcastClient);
    }

    @Override
    public JobExecutionEnvironment restoreExecutionContext(@NonNull String filePath, @NonNull JobConfig jobConfig, @NonNull Long jobId) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked non-null but is null");
        }
        if (jobId == null) {
            throw new NullPointerException("jobId is marked non-null but is null");
        }
        return new JobExecutionEnvironment(jobConfig, filePath, this.hazelcastClient, true, jobId);
    }

    @Override
    public JobClient createJobClient() {
        return new JobClient(this.hazelcastClient);
    }

    @Override
    public void close() {
        this.hazelcastClient.getHazelcastInstance().shutdown();
    }

    public ILogger getLogger() {
        return this.hazelcastClient.getLogger(this.getClass());
    }

    public String printMessageToMaster(@NonNull String msg) {
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        return (String)this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelPrintMessageCodec.encodeRequest((String)msg), SeaTunnelPrintMessageCodec::decodeResponse);
    }

    public void shutdown() {
        this.hazelcastClient.shutdown();
    }

    @Deprecated
    public String getJobDetailStatus(Long jobId) {
        return this.jobClient.getJobDetailStatus(jobId);
    }

    @Deprecated
    public String listJobStatus() {
        return this.jobClient.listJobStatus(false);
    }

    @Deprecated
    public String getJobStatus(Long jobId) {
        return this.jobClient.getJobStatus(jobId);
    }

    @Deprecated
    public String getJobMetrics(Long jobId) {
        return this.jobClient.getJobMetrics(jobId);
    }

    @Deprecated
    public void savePointJob(Long jobId) {
        this.jobClient.savePointJob(jobId);
    }

    @Deprecated
    public void cancelJob(Long jobId) {
        this.jobClient.cancelJob(jobId);
    }

    public JobDAGInfo getJobInfo(Long jobId) {
        return this.jobClient.getJobInfo(jobId);
    }

    public JobMetricsRunner.JobMetricsSummary getJobMetricsSummary(Long jobId) {
        return this.jobClient.getJobMetricsSummary(jobId);
    }

    public Map<String, String> getClusterHealthMetrics() {
        Set members = this.hazelcastClient.getHazelcastInstance().getCluster().getMembers();
        HashMap<String, String> healthMetricsMap = new HashMap<String, String>();
        members.stream().forEach(member -> {
            String metrics = (String)this.hazelcastClient.requestAndDecodeResponse(member.getUuid(), SeaTunnelGetClusterHealthMetricsCodec.encodeRequest(), SeaTunnelGetClusterHealthMetricsCodec::decodeResponse);
            String[] split = metrics.split(",");
            LinkedHashMap kvMap = new LinkedHashMap();
            Arrays.stream(split).forEach(kv -> {
                String[] kvArr = kv.split("=");
                kvMap.put(kvArr[0], kvArr[1]);
            });
            healthMetricsMap.put(member.getAddress().toString(), JsonUtils.toJsonString(kvMap));
        });
        return healthMetricsMap;
    }

    public JobClient getJobClient() {
        return this.jobClient;
    }
}

