/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.job;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.core.serializable.JobDataSerializerHook;

public class JobImmutableInformation
implements IdentifiedDataSerializable {
    private long jobId;
    private String jobName;
    private boolean isStartWithSavePoint;
    private long createTime;
    private Data logicalDag;
    private JobConfig jobConfig;
    private List<URL> pluginJarsUrls;

    public JobImmutableInformation() {
    }

    public JobImmutableInformation(long jobId, String jobName, boolean isStartWithSavePoint, @NonNull Data logicalDag, @NonNull JobConfig jobConfig, @NonNull List<URL> pluginJarsUrls) {
        if (logicalDag == null) {
            throw new NullPointerException("logicalDag is marked non-null but is null");
        }
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked non-null but is null");
        }
        if (pluginJarsUrls == null) {
            throw new NullPointerException("pluginJarsUrls is marked non-null but is null");
        }
        this.createTime = System.currentTimeMillis();
        this.jobId = jobId;
        this.jobName = jobName;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.logicalDag = logicalDag;
        this.jobConfig = jobConfig;
        this.pluginJarsUrls = pluginJarsUrls;
    }

    public JobImmutableInformation(long jobId, String jobName, @NonNull Data logicalDag, @NonNull JobConfig jobConfig, @NonNull List<URL> pluginJarsUrls) {
        this(jobId, jobName, false, logicalDag, jobConfig, pluginJarsUrls);
        if (logicalDag == null) {
            throw new NullPointerException("logicalDag is marked non-null but is null");
        }
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked non-null but is null");
        }
        if (pluginJarsUrls == null) {
            throw new NullPointerException("pluginJarsUrls is marked non-null but is null");
        }
    }

    public long getJobId() {
        return this.jobId;
    }

    public boolean isStartWithSavePoint() {
        return this.isStartWithSavePoint;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Data getLogicalDag() {
        return this.logicalDag;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    public List<URL> getPluginJarsUrls() {
        return this.pluginJarsUrls;
    }

    public int getFactoryId() {
        return JobDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 3;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeString(this.jobName);
        out.writeBoolean(this.isStartWithSavePoint);
        out.writeLong(this.createTime);
        IOUtil.writeData((ObjectDataOutput)out, (Data)this.logicalDag);
        out.writeObject((Object)this.jobConfig);
        out.writeObject(this.pluginJarsUrls);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.jobName = in.readString();
        this.isStartWithSavePoint = in.readBoolean();
        this.createTime = in.readLong();
        this.logicalDag = IOUtil.readData((ObjectDataInput)in);
        this.jobConfig = (JobConfig)in.readObject();
        this.pluginJarsUrls = (List)in.readObject();
    }
}

