/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.processor;

import com.hazelcast.cache.EventJournalCacheEvent;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.ToResultSetFunction;
import com.hazelcast.jet.impl.connector.ConvenientSourceP;
import com.hazelcast.jet.impl.connector.HazelcastReaders;
import com.hazelcast.jet.impl.connector.ReadFilesP;
import com.hazelcast.jet.impl.connector.ReadJdbcP;
import com.hazelcast.jet.impl.connector.StreamEventJournalP;
import com.hazelcast.jet.impl.connector.StreamFilesP;
import com.hazelcast.jet.impl.connector.StreamJmsP;
import com.hazelcast.jet.impl.connector.StreamSocketP;
import com.hazelcast.jet.impl.pipeline.SourceBufferImpl;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.map.EventJournalMapEvent;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.ConnectorPermission;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.Permission;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public final class SourceProcessors {
    private SourceProcessors() {
    }

    @Nonnull
    public static ProcessorMetaSupplier readMapP(@Nonnull String mapName) {
        return HazelcastReaders.readLocalMapSupplier(mapName);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier readMapP(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        return HazelcastReaders.readLocalMapSupplier(mapName, predicate, projection);
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier streamMapP(@Nonnull String mapName, @Nonnull JournalInitialPosition initialPos, @Nonnull EventTimePolicy<? super Map.Entry<K, V>> eventTimePolicy) {
        return SourceProcessors.streamMapP(mapName, Util.mapPutEvents(), Util.mapEventToEntry(), initialPos, eventTimePolicy);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier streamMapP(@Nonnull String mapName, @Nonnull PredicateEx<? super EventJournalMapEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalMapEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        return StreamEventJournalP.streamMapSupplier(mapName, predicateFn, projectionFn, initialPos, eventTimePolicy);
    }

    @Nonnull
    public static ProcessorSupplier readRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return HazelcastReaders.readRemoteMapSupplier(mapName, clientConfig);
    }

    @Nonnull
    public static <T, K, V> ProcessorSupplier readRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        return HazelcastReaders.readRemoteMapSupplier(mapName, clientConfig, predicate, projection);
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier streamRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull JournalInitialPosition initialPos, @Nonnull EventTimePolicy<? super Map.Entry<K, V>> eventTimePolicy) {
        return SourceProcessors.streamRemoteMapP(mapName, clientConfig, Util.mapPutEvents(), Util.mapEventToEntry(), initialPos, eventTimePolicy);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier streamRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull PredicateEx<? super EventJournalMapEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalMapEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return StreamEventJournalP.streamRemoteMapSupplier(mapName, clientXml, predicateFn, projectionFn, initialPos, eventTimePolicy);
    }

    @Nonnull
    public static ProcessorMetaSupplier readCacheP(@Nonnull String cacheName) {
        return HazelcastReaders.readLocalCacheSupplier(cacheName);
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier streamCacheP(@Nonnull String cacheName, @Nonnull JournalInitialPosition initialPos, @Nonnull EventTimePolicy<? super Map.Entry<K, V>> eventTimePolicy) {
        return SourceProcessors.streamCacheP(cacheName, Util.cachePutEvents(), Util.cacheEventToEntry(), initialPos, eventTimePolicy);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier streamCacheP(@Nonnull String cacheName, @Nonnull PredicateEx<? super EventJournalCacheEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalCacheEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        return StreamEventJournalP.streamCacheSupplier(cacheName, predicateFn, projectionFn, initialPos, eventTimePolicy);
    }

    @Nonnull
    public static ProcessorSupplier readRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return HazelcastReaders.readRemoteCacheSupplier(cacheName, clientConfig);
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier streamRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nonnull JournalInitialPosition initialPos, @Nonnull EventTimePolicy<? super Map.Entry<K, V>> eventTimePolicy) {
        return SourceProcessors.streamRemoteCacheP(cacheName, clientConfig, Util.cachePutEvents(), Util.cacheEventToEntry(), initialPos, eventTimePolicy);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier streamRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nonnull PredicateEx<? super EventJournalCacheEvent<K, V>> predicateFn, @Nonnull FunctionEx<? super EventJournalCacheEvent<K, V>, ? extends T> projectionFn, @Nonnull JournalInitialPosition initialPos, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return StreamEventJournalP.streamRemoteCacheSupplier(cacheName, clientXml, predicateFn, projectionFn, initialPos, eventTimePolicy);
    }

    @Nonnull
    public static ProcessorMetaSupplier readListP(@Nonnull String listName) {
        return HazelcastReaders.localOrRemoteListSupplier(listName, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier readRemoteListP(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return HazelcastReaders.localOrRemoteListSupplier(listName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier streamSocketP(@Nonnull String host, int port, @Nonnull Charset charset) {
        return StreamSocketP.supplier(host, port, charset.name());
    }

    @Nonnull
    public static <R> ProcessorMetaSupplier readFilesP(@Nonnull String directory, @Nonnull Charset charset, @Nonnull String glob, boolean sharedFileSystem, @Nonnull BiFunctionEx<? super String, ? super String, ? extends R> mapOutputFn) {
        String charsetName = charset.name();
        return SourceProcessors.readFilesP(directory, glob, sharedFileSystem, SecuredFunctions.readFileFn(directory, charsetName, mapOutputFn));
    }

    @Nonnull
    public static <I> ProcessorMetaSupplier readFilesP(@Nonnull String directory, @Nonnull String glob, boolean sharedFileSystem, @Nonnull FunctionEx<? super Path, ? extends Stream<I>> readFileFn) {
        return SourceProcessors.readFilesP(directory, glob, sharedFileSystem, true, readFileFn);
    }

    @Nonnull
    public static <I> ProcessorMetaSupplier readFilesP(@Nonnull String directory, @Nonnull String glob, boolean sharedFileSystem, boolean ignoreFileNotFound, @Nonnull FunctionEx<? super Path, ? extends Stream<I>> readFileFn) {
        return ReadFilesP.metaSupplier(directory, glob, sharedFileSystem, ignoreFileNotFound, readFileFn);
    }

    @Nonnull
    public static ProcessorMetaSupplier streamFilesP(@Nonnull String watchedDirectory, @Nonnull Charset charset, @Nonnull String glob, boolean sharedFileSystem, @Nonnull BiFunctionEx<? super String, ? super String, ?> mapOutputFn) {
        return StreamFilesP.metaSupplier(watchedDirectory, charset.name(), glob, sharedFileSystem, mapOutputFn);
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier streamJmsQueueP(@Nullable String destination, @Nonnull ProcessingGuarantee maxGuarantee, @Nonnull EventTimePolicy<? super T> eventTimePolicy, @Nonnull SupplierEx<? extends Connection> newConnectionFn, @Nonnull FunctionEx<? super Session, ? extends MessageConsumer> consumerFn, @Nonnull FunctionEx<? super Message, ?> messageIdFn, @Nonnull FunctionEx<? super Message, ? extends T> projectionFn) {
        return ProcessorMetaSupplier.preferLocalParallelismOne((Permission)ConnectorPermission.jms(destination, "read"), new StreamJmsP.Supplier<T>(destination, maxGuarantee, eventTimePolicy, newConnectionFn, consumerFn, messageIdFn, projectionFn));
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier streamJmsTopicP(@Nullable String destination, boolean isSharedConsumer, @Nonnull ProcessingGuarantee maxGuarantee, @Nonnull EventTimePolicy<? super T> eventTimePolicy, @Nonnull SupplierEx<? extends Connection> newConnectionFn, @Nonnull FunctionEx<? super Session, ? extends MessageConsumer> consumerFn, @Nonnull FunctionEx<? super Message, ?> messageIdFn, @Nonnull FunctionEx<? super Message, ? extends T> projectionFn) {
        StreamJmsP.Supplier<? extends T> pSupplier = new StreamJmsP.Supplier<T>(destination, maxGuarantee, eventTimePolicy, newConnectionFn, consumerFn, messageIdFn, projectionFn);
        ConnectorPermission permission = ConnectorPermission.jms(destination, "read");
        return isSharedConsumer ? ProcessorMetaSupplier.preferLocalParallelismOne((Permission)permission, pSupplier) : ProcessorMetaSupplier.forceTotalParallelismOne(pSupplier, UuidUtil.newUnsecureUuidString(), permission);
    }

    public static <T> ProcessorMetaSupplier readJdbcP(@Nonnull SupplierEx<? extends java.sql.Connection> newConnectionFn, @Nonnull ToResultSetFunction resultSetFn, @Nonnull FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        return ReadJdbcP.supplier(newConnectionFn, resultSetFn, mapOutputFn);
    }

    public static <T> ProcessorMetaSupplier readJdbcP(@Nonnull String connectionURL, @Nonnull String query, @Nonnull FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        return ReadJdbcP.supplier(connectionURL, query, mapOutputFn);
    }

    @Nonnull
    public static <C, T, S> ProcessorMetaSupplier convenientSourceP(@Nonnull FunctionEx<? super Processor.Context, ? extends C> createFn, @Nonnull BiConsumerEx<? super C, ? super SourceBuilder.SourceBuffer<T>> fillBufferFn, @Nonnull FunctionEx<? super C, ? extends S> createSnapshotFn, @Nonnull BiConsumerEx<? super C, ? super List<S>> restoreSnapshotFn, @Nonnull ConsumerEx<? super C> destroyFn, int preferredLocalParallelism, boolean isBatch, @Nullable Permission permission) {
        com.hazelcast.jet.impl.util.Util.checkSerializable(createFn, "createFn");
        com.hazelcast.jet.impl.util.Util.checkSerializable(fillBufferFn, "fillBufferFn");
        com.hazelcast.jet.impl.util.Util.checkSerializable(destroyFn, "destroyFn");
        com.hazelcast.jet.impl.util.Util.checkSerializable(createSnapshotFn, "createSnapshotFn");
        com.hazelcast.jet.impl.util.Util.checkSerializable(restoreSnapshotFn, "restoreSnapshotFn");
        Preconditions.checkNotNegative(preferredLocalParallelism + 1, "preferredLocalParallelism must >= -1");
        ProcessorSupplier procSup = ProcessorSupplier.of(() -> new ConvenientSourceP(createFn, fillBufferFn, createSnapshotFn, restoreSnapshotFn, destroyFn, new SourceBufferImpl.Plain(isBatch), null));
        return preferredLocalParallelism != 0 ? ProcessorMetaSupplier.of(preferredLocalParallelism, permission, procSup) : ProcessorMetaSupplier.forceTotalParallelismOne(procSup, permission);
    }

    @Nonnull
    public static <C, T, S> ProcessorMetaSupplier convenientTimestampedSourceP(@Nonnull FunctionEx<? super Processor.Context, ? extends C> createFn, @Nonnull BiConsumerEx<? super C, ? super SourceBuilder.TimestampedSourceBuffer<T>> fillBufferFn, @Nonnull EventTimePolicy<? super T> eventTimePolicy, @Nonnull FunctionEx<? super C, ? extends S> createSnapshotFn, @Nonnull BiConsumerEx<? super C, ? super List<S>> restoreSnapshotFn, @Nonnull ConsumerEx<? super C> destroyFn, int preferredLocalParallelism) {
        com.hazelcast.jet.impl.util.Util.checkSerializable(createFn, "createFn");
        com.hazelcast.jet.impl.util.Util.checkSerializable(fillBufferFn, "fillBufferFn");
        com.hazelcast.jet.impl.util.Util.checkSerializable(destroyFn, "destroyFn");
        com.hazelcast.jet.impl.util.Util.checkSerializable(createSnapshotFn, "createSnapshotFn");
        com.hazelcast.jet.impl.util.Util.checkSerializable(restoreSnapshotFn, "restoreSnapshotFn");
        Preconditions.checkNotNegative(preferredLocalParallelism + 1, "preferredLocalParallelism must >= -1");
        ProcessorSupplier procSup = ProcessorSupplier.of(() -> new ConvenientSourceP(createFn, fillBufferFn, createSnapshotFn, restoreSnapshotFn, destroyFn, new SourceBufferImpl.Timestamped(), eventTimePolicy));
        return preferredLocalParallelism > 0 ? ProcessorMetaSupplier.of(preferredLocalParallelism, procSup) : ProcessorMetaSupplier.forceTotalParallelismOne(procSup);
    }
}

