/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.sedona.core.formatMapper.shapefileParser.boundary.BoundBox;
import org.apache.sedona.core.formatMapper.shapefileParser.boundary.BoundaryInputFormat;
import org.apache.sedona.core.formatMapper.shapefileParser.fieldname.FieldnameInputFormat;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.PrimitiveShape;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeInputFormat;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;
import org.apache.sedona.core.spatialRDD.LineStringRDD;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.sedona.core.spatialRDD.PolygonRDD;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Tuple2;

public class ShapefileReader {
    public static SpatialRDD<Geometry> readToGeometryRDD(JavaSparkContext sc, String inputPath) {
        return ShapefileReader.readToGeometryRDD(sc, inputPath, new GeometryFactory());
    }

    public static SpatialRDD<Geometry> readToGeometryRDD(JavaSparkContext sc, String inputPath, GeometryFactory geometryFactory) {
        SpatialRDD<Geometry> spatialRDD = new SpatialRDD<Geometry>();
        spatialRDD.rawSpatialRDD = ShapefileReader.readShapefile(sc, inputPath, geometryFactory);
        try {
            spatialRDD.fieldNames = ShapefileReader.readFieldNames(sc, inputPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return spatialRDD;
    }

    private static JavaRDD<Geometry> readShapefile(JavaSparkContext sc, String inputPath, final GeometryFactory geometryFactory) {
        JavaPairRDD shapePrimitiveRdd = sc.newAPIHadoopFile(inputPath, ShapeInputFormat.class, ShapeKey.class, PrimitiveShape.class, sc.hadoopConfiguration());
        return shapePrimitiveRdd.map((Function)new Function<Tuple2<ShapeKey, PrimitiveShape>, Geometry>(){

            public Geometry call(Tuple2<ShapeKey, PrimitiveShape> primitiveTuple) throws Exception {
                return ((PrimitiveShape)primitiveTuple._2()).getShape(geometryFactory);
            }
        });
    }

    public static BoundBox readBoundBox(JavaSparkContext sc, String inputPath) {
        JavaPairRDD bounds = sc.newAPIHadoopFile(inputPath, BoundaryInputFormat.class, Long.class, BoundBox.class, sc.hadoopConfiguration());
        if ((bounds = bounds.reduceByKey((Function2)new Function2<BoundBox, BoundBox, BoundBox>(){

            public BoundBox call(BoundBox box1, BoundBox box2) throws Exception {
                return BoundBox.mergeBoundBox(box1, box2);
            }
        })).count() > 0L) {
            return new BoundBox((BoundBox)((Tuple2)bounds.collect().get(0))._2());
        }
        return null;
    }

    public static List<String> readFieldNames(JavaSparkContext sc, String inputPath) throws IOException {
        JavaPairRDD fieldDescriptors = sc.newAPIHadoopFile(inputPath, FieldnameInputFormat.class, Long.class, String.class, sc.hadoopConfiguration());
        List<String> result2 = Arrays.asList(((String)((Tuple2)(fieldDescriptors = fieldDescriptors.reduceByKey((Function2)new Function2<String, String, String>(){

            public String call(String descripter1, String descripter2) throws Exception {
                return descripter1 + " " + descripter2;
            }
        })).collect().get(0))._2()).split("\t"));
        if (result2.size() > 1) {
            return result2;
        }
        if (result2.size() == 1) {
            if (result2.get(0).equalsIgnoreCase("")) {
                return null;
            }
            return result2;
        }
        return null;
    }

    public static PolygonRDD readToPolygonRDD(JavaSparkContext sc, String inputPath) {
        return ShapefileReader.geometryToPolygon(ShapefileReader.readToGeometryRDD(sc, inputPath));
    }

    public static PolygonRDD readToPolygonRDD(JavaSparkContext sc, String inputPath, GeometryFactory geometryFactory) {
        return ShapefileReader.geometryToPolygon(ShapefileReader.readToGeometryRDD(sc, inputPath, geometryFactory));
    }

    public static PolygonRDD geometryToPolygon(SpatialRDD geometryRDD) {
        PolygonRDD polygonRDD = new PolygonRDD((JavaRDD<Polygon>)geometryRDD.rawSpatialRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, Polygon>(){

            public Iterator<Polygon> call(Geometry spatialObject) throws Exception {
                ArrayList<Polygon> result2 = new ArrayList<Polygon>();
                if (spatialObject instanceof MultiPolygon) {
                    MultiPolygon multiObjects = (MultiPolygon)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        Polygon oneObject = (Polygon)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result2.add(oneObject);
                    }
                } else if (spatialObject instanceof Polygon) {
                    result2.add((Polygon)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getPolygonRDD] the object type is not Polygon or MultiPolygon type. It is " + spatialObject.getGeometryType());
                }
                return result2.iterator();
            }
        }));
        polygonRDD.fieldNames = geometryRDD.fieldNames;
        return polygonRDD;
    }

    public static PointRDD readToPointRDD(JavaSparkContext sc, String inputPath) {
        return ShapefileReader.geometryToPoint(ShapefileReader.readToGeometryRDD(sc, inputPath));
    }

    public static PointRDD readToPointRDD(JavaSparkContext sc, String inputPath, GeometryFactory geometryFactory) {
        return ShapefileReader.geometryToPoint(ShapefileReader.readToGeometryRDD(sc, inputPath, geometryFactory));
    }

    public static PointRDD geometryToPoint(SpatialRDD geometryRDD) {
        PointRDD pointRDD = new PointRDD((JavaRDD<Point>)geometryRDD.rawSpatialRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, Point>(){

            public Iterator<Point> call(Geometry spatialObject) throws Exception {
                ArrayList<Point> result2 = new ArrayList<Point>();
                if (spatialObject instanceof MultiPoint) {
                    MultiPoint multiObjects = (MultiPoint)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        Point oneObject = (Point)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result2.add(oneObject);
                    }
                } else if (spatialObject instanceof Point) {
                    result2.add((Point)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getPointRDD] the object type is not Point or MultiPoint type. It is " + spatialObject.getGeometryType());
                }
                return result2.iterator();
            }
        }));
        pointRDD.fieldNames = geometryRDD.fieldNames;
        return pointRDD;
    }

    public static LineStringRDD readToLineStringRDD(JavaSparkContext sc, String inputPath) {
        return ShapefileReader.geometryToLineString(ShapefileReader.readToGeometryRDD(sc, inputPath));
    }

    public static LineStringRDD readToLineStringRDD(JavaSparkContext sc, String inputPath, GeometryFactory geometryFactory) {
        return ShapefileReader.geometryToLineString(ShapefileReader.readToGeometryRDD(sc, inputPath, geometryFactory));
    }

    public static LineStringRDD geometryToLineString(SpatialRDD geometryRDD) {
        LineStringRDD lineStringRDD = new LineStringRDD((JavaRDD<LineString>)geometryRDD.rawSpatialRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, LineString>(){

            public Iterator<LineString> call(Geometry spatialObject) throws Exception {
                ArrayList<LineString> result2 = new ArrayList<LineString>();
                if (spatialObject instanceof MultiLineString) {
                    MultiLineString multiObjects = (MultiLineString)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        LineString oneObject = (LineString)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result2.add(oneObject);
                    }
                } else if (spatialObject instanceof LineString) {
                    result2.add((LineString)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getLineStringRDD] the object type is not LineString or MultiLineString type. It is " + spatialObject.getGeometryType());
                }
                return result2.iterator();
            }
        }));
        lineStringRDD.fieldNames = geometryRDD.fieldNames;
        return lineStringRDD;
    }
}

