/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.subDivide;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class PivotFinder {
    private static final double DBL_MAX = Double.MAX_VALUE;
    private static GeometryFactory geometryFactory = new GeometryFactory();

    public static double findPivot(Geometry geom, boolean splitOrdinate, double center, int numberOfVertices) {
        double pivot = Double.MAX_VALUE;
        if (geom instanceof Polygon) {
            double pivotEps = Double.MAX_VALUE;
            Polygon lwPoly = (Polygon)geom.copy();
            LinearRing ringToTrim = lwPoly.getExteriorRing();
            if (numberOfVertices >= 2 * lwPoly.getExteriorRing().getNumPoints()) {
                double maxArea = geometryFactory.createPolygon(lwPoly.getExteriorRing()).getArea();
                for (int i = 0; i < lwPoly.getNumInteriorRing(); ++i) {
                    LinearRing curHole = lwPoly.getInteriorRingN(i);
                    double holeArea = geometryFactory.createPolygon(curHole).getArea();
                    if (!(holeArea > maxArea)) continue;
                    maxArea = holeArea;
                    ringToTrim = curHole;
                }
            }
            for (int i = 0; i < ringToTrim.getNumPoints(); ++i) {
                double pt = splitOrdinate ? ringToTrim.getPointN(i).getY() : ringToTrim.getPointN(i).getX();
                double ptEps = Math.abs(pt - center);
                if (!(pivotEps > ptEps)) continue;
                pivot = pt;
                pivotEps = ptEps;
            }
        }
        if (pivot == Double.MAX_VALUE) {
            return center;
        }
        return pivot;
    }
}

