/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.StringLocker;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.netcdf3.N3headerNew;
import ucar.nc2.internal.iosp.netcdf3.N3iospNew;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.IO;
import ucar.nc2.util.rc.RC;
import ucar.unidata.io.InMemoryRandomAccessFile;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.UncompressInputStream;
import ucar.unidata.io.bzip2.CBZip2InputStream;
import ucar.unidata.io.spi.RandomAccessFileProvider;
import ucar.unidata.util.StringUtil2;

public class NetcdfFiles {
    private static final Logger log;
    private static final List<IOServiceProvider> registeredProviders;
    private static final List<RandomAccessFileProvider> registeredRandomAccessFileProviders;
    private static final int default_buffersize = 8092;
    private static final StringLocker stringLocker;
    private static final List<String> possibleCompressedSuffixes;
    private static boolean loadWarnings;
    private static boolean userLoads;
    public static final String reservedFullName = ".\\";
    private static final String reservedSectionSpec = "();,.\\";
    private static final String reservedCdl = "[ !\"#$%&'()*,:;<=>?[]^`{|}~\\";

    public static void registerIOProvider(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> ioClass = NetcdfFile.class.getClassLoader().loadClass(className);
        NetcdfFiles.registerIOProvider(ioClass);
    }

    public static void registerIOProvider(Class iospClass) throws IllegalAccessException, InstantiationException {
        NetcdfFiles.registerIOProvider(iospClass, false);
    }

    private static void registerIOProvider(Class iospClass, boolean last) throws IllegalAccessException, InstantiationException {
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (userLoads && !last) {
            registeredProviders.add(0, spi);
        } else {
            registeredProviders.add(spi);
        }
    }

    public static void registerRandomAccessFileProvider(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> rafClass = NetcdfFile.class.getClassLoader().loadClass(className);
        NetcdfFiles.registerRandomAccessFileProvider(rafClass);
    }

    public static void registerRandomAccessFileProvider(Class rafClass) throws IllegalAccessException, InstantiationException {
        NetcdfFiles.registerRandomAccessFileProvider(rafClass, false);
    }

    private static void registerRandomAccessFileProvider(Class rafClass, boolean last) throws IllegalAccessException, InstantiationException {
        RandomAccessFileProvider rafProvider = (RandomAccessFileProvider)rafClass.newInstance();
        if (userLoads && !last) {
            registeredRandomAccessFileProviders.add(0, rafProvider);
        } else {
            registeredRandomAccessFileProviders.add(rafProvider);
        }
    }

    public static NetcdfFile open(String location) throws IOException {
        return NetcdfFiles.open(location, -1, null);
    }

    public static NetcdfFile open(String location, CancelTask cancelTask) throws IOException {
        return NetcdfFiles.open(location, -1, cancelTask);
    }

    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask) throws IOException {
        return NetcdfFiles.open(location, buffer_size, cancelTask, null);
    }

    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        RandomAccessFile raf = NetcdfFiles.getRaf(location, buffer_size);
        try {
            return NetcdfFiles.open(raf, location, cancelTask, iospMessage);
        }
        catch (Throwable t) {
            raf.close();
            throw new IOException(t);
        }
    }

    public static NetcdfFile open(String location, String iospClassName, int bufferSize, CancelTask cancelTask, Object iospMessage) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (bufferSize <= 0) {
            bufferSize = 8092;
        }
        RandomAccessFile raf = RandomAccessFile.acquire(NetcdfFiles.canonicalizeUriString(location), bufferSize);
        NetcdfFile result = NetcdfFiles.build(spi, raf, location, cancelTask);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return result;
    }

    public static boolean canOpen(String location) throws IOException {
        boolean canOpen = false;
        try (RandomAccessFile raf = NetcdfFiles.getRaf(location, -1);){
            if (raf != null) {
                log.info(String.format("%s can be accessed with %s", raf.getLocation(), raf.getClass()));
                IOServiceProvider iosp = NetcdfFiles.getIosp(raf);
                if (iosp != null) {
                    canOpen = true;
                    log.info(String.format("%s can be opened by %s", raf.getLocation(), iosp.getClass()));
                }
            }
        }
        return canOpen;
    }

    public static String canonicalizeUriString(String location) {
        if (location == null) {
            return null;
        }
        String uriString = location.trim();
        if (uriString.startsWith("file://")) {
            uriString = uriString.substring(7);
        } else if (uriString.startsWith("file:")) {
            uriString = uriString.substring(5);
        }
        return StringUtil2.replace(uriString, '\\', "/");
    }

    private static RandomAccessFile downloadAndDecompress(RandomAccessFile raf, String uriString, int buffer_size) throws IOException {
        int pos = uriString.lastIndexOf(47);
        if (pos < 0) {
            pos = uriString.lastIndexOf(58);
        }
        String tmp = System.getProperty("java.io.tmpdir");
        String filename = uriString.substring(pos + 1);
        String sep = File.separator;
        uriString = DiskCache.getFileStandardPolicy(tmp + sep + filename).getPath();
        NetcdfFiles.copy(raf, (OutputStream)new FileOutputStream(uriString), 0x100000);
        try {
            String uncompressedFileName = NetcdfFiles.makeUncompressed(uriString);
            return RandomAccessFile.acquire(uncompressedFileName, buffer_size);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessFile getRaf(String location, int buffer_size) throws IOException {
        String uriString = location.trim();
        if (buffer_size <= 0) {
            buffer_size = 8092;
        }
        RandomAccessFile raf = null;
        for (RandomAccessFileProvider provider : registeredRandomAccessFileProviders) {
            if (!provider.isOwnerOf(location)) continue;
            raf = provider.open(location, buffer_size);
            if (!NetcdfFiles.looksCompressed(uriString) || raf.isDirectory()) break;
            raf = NetcdfFiles.downloadAndDecompress(raf, uriString, buffer_size);
            break;
        }
        if (raf == null) {
            for (RandomAccessFileProvider provider : ServiceLoader.load(RandomAccessFileProvider.class)) {
                if (!provider.isOwnerOf(location)) continue;
                raf = provider.open(location, buffer_size);
                if (!NetcdfFiles.looksCompressed(uriString) || raf.isDirectory()) break;
                raf = NetcdfFiles.downloadAndDecompress(raf, uriString, buffer_size);
                break;
            }
        }
        if (raf == null) {
            if ((uriString = StringUtil2.replace(uriString, '\\', "/")).startsWith("file:")) {
                uriString = StringUtil2.unescape(uriString.substring(5));
            }
            String uncompressedFileName = null;
            if (NetcdfFiles.looksCompressed(uriString)) {
                try {
                    stringLocker.control(uriString);
                    uncompressedFileName = NetcdfFiles.makeUncompressed(uriString);
                }
                catch (Exception e) {
                    log.warn("Failed to uncompress {}, err= {}; try as a regular file.", (Object)uriString, (Object)e.getMessage());
                }
                finally {
                    stringLocker.release(uriString);
                }
            }
            raf = uncompressedFileName != null ? RandomAccessFile.acquire(uncompressedFileName, buffer_size) : RandomAccessFile.acquire(uriString, buffer_size);
        }
        if (raf == null) {
            throw new IOException("Could not find an appropriate RandomAccessFileProvider to open " + location);
        }
        return raf;
    }

    private static boolean looksCompressed(String filename) {
        return possibleCompressedSuffixes.stream().anyMatch(compressedSuffix -> filename.endsWith("." + compressedSuffix)) || possibleCompressedSuffixes.stream().anyMatch(compressedSuffix -> filename.contains("." + compressedSuffix + "/"));
    }

    private static String findCompressedSuffix(String filename) {
        if (possibleCompressedSuffixes.stream().anyMatch(compressedSuffix -> filename.endsWith("." + compressedSuffix))) {
            return filename.substring(filename.lastIndexOf(46) + 1);
        }
        return possibleCompressedSuffixes.stream().filter(compressedSuffix -> filename.contains("." + compressedSuffix + "/")).findFirst().orElse("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String makeUncompressed(String filename) throws Exception {
        String suffix = NetcdfFiles.findCompressedSuffix(filename);
        int pos = filename.lastIndexOf(suffix);
        String basepath = filename.substring(0, pos - 1);
        String itempath = filename.substring(pos + suffix.length());
        String uncompressedFilename = basepath + itempath;
        String baseFilename = basepath + "." + suffix;
        File uncompressedFile = DiskCache.getFileStandardPolicy(uncompressedFilename);
        if (uncompressedFile.exists() && uncompressedFile.length() > 0L) {
            FileInputStream stream = null;
            FileLock lock = null;
            try {
                stream = new FileInputStream(uncompressedFile);
                while (true) {
                    try {
                        lock = stream.getChannel().lock(0L, 1L, true);
                    }
                    catch (OverlappingFileLockException oe) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e1) {}
                        break;
                    }
                }
                if (NetcdfFile.debugCompress) {
                    log.info("found uncompressed {} for {}", (Object)uncompressedFile, (Object)filename);
                }
                String string = uncompressedFile.getPath();
                return string;
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        File file = new File(baseFilename);
        if (!file.exists()) {
            return null;
        }
        try (FileOutputStream fout = new FileOutputStream(uncompressedFile);){
            FileLock lock;
            while (true) {
                try {
                    lock = fout.getChannel().lock(0L, 1L, false);
                }
                catch (OverlappingFileLockException oe) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                break;
            }
            try {
                if (suffix.equalsIgnoreCase("Z")) {
                    try (UncompressInputStream in = new UncompressInputStream(new FileInputStream(baseFilename));){
                        NetcdfFiles.copy(in, (OutputStream)fout, 100000);
                    }
                    if (!NetcdfFile.debugCompress) return uncompressedFile.getPath();
                    log.info("uncompressed {} to {}", (Object)filename, (Object)uncompressedFile);
                    return uncompressedFile.getPath();
                }
                if (suffix.equalsIgnoreCase("zip")) {
                    try (ZipInputStream zin = new ZipInputStream(new FileInputStream(baseFilename));){
                        ZipEntry ze = zin.getNextEntry();
                        String itemName = itempath.substring(1);
                        while (ze != null) {
                            if (itempath.isEmpty() || ze.getName().equals(itemName)) {
                                NetcdfFiles.copy(zin, (OutputStream)fout, 100000);
                                if (!NetcdfFile.debugCompress) return uncompressedFile.getPath();
                                log.info("unzipped {} entry {} to {}", new Object[]{filename, ze.getName(), uncompressedFile});
                                return uncompressedFile.getPath();
                            }
                            zin.closeEntry();
                            ze = zin.getNextEntry();
                        }
                        return uncompressedFile.getPath();
                    }
                }
                if (suffix.equalsIgnoreCase("bz2")) {
                    try (CBZip2InputStream in = new CBZip2InputStream(new FileInputStream(baseFilename), true);){
                        NetcdfFiles.copy(in, (OutputStream)fout, 100000);
                    }
                    if (!NetcdfFile.debugCompress) return uncompressedFile.getPath();
                    log.info("unbzipped {} to {}", (Object)filename, (Object)uncompressedFile);
                    return uncompressedFile.getPath();
                }
                if (!suffix.equalsIgnoreCase("gzip")) {
                    if (!suffix.equalsIgnoreCase("gz")) return uncompressedFile.getPath();
                }
                try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(baseFilename));){
                    NetcdfFiles.copy(in, (OutputStream)fout, 100000);
                }
                if (!NetcdfFile.debugCompress) return uncompressedFile.getPath();
                log.info("ungzipped {} to {}", (Object)filename, (Object)uncompressedFile);
                return uncompressedFile.getPath();
            }
            catch (Exception e) {
                if (!uncompressedFile.exists()) throw e;
                if (uncompressedFile.delete()) throw e;
                log.warn("failed to delete uncompressed file (IOException) {}", (Object)uncompressedFile);
                throw e;
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
    }

    private static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private static void copy(RandomAccessFile in, OutputStream out, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int bytesRead = 0;
        for (long length = in.length(); length > 0L; length -= (long)bufferSize) {
            if (length > (long)bufferSize) {
                in.readFully(buffer, 0, bufferSize);
                bytesRead = bufferSize;
            } else if (length <= (long)bufferSize) {
                in.readFully(buffer, 0, (int)length);
                bytesRead = (int)length;
            }
            out.write(buffer, 0, bytesRead);
        }
    }

    public static NetcdfFile openInMemory(String filename) throws IOException {
        File file = new File(filename);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));){
            IO.copy(in, bos);
        }
        return NetcdfFiles.openInMemory(filename, bos.toByteArray());
    }

    public static NetcdfFile openInMemory(URI uri) throws IOException {
        byte[] contents;
        URL url = uri.toURL();
        try (InputStream in = url.openStream();){
            contents = IO.readContentsToByteArray(in);
        }
        return NetcdfFiles.openInMemory(uri.toString(), contents);
    }

    public static NetcdfFile openInMemory(String name, byte[] data) throws IOException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        return NetcdfFiles.open(raf, name, null, null);
    }

    public static NetcdfFile openInMemory(String name, byte[] data, String iospClassName) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        return NetcdfFiles.build(spi, raf, name, null);
    }

    public static NetcdfFile open(RandomAccessFile raf, String location, CancelTask cancelTask, Object iospMessage) throws IOException {
        IOServiceProvider spi = NetcdfFiles.getIosp(raf);
        if (spi == null) {
            raf.close();
            throw new IOException("Cant read " + location + ": not a valid CDM file.");
        }
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (log.isDebugEnabled()) {
            log.debug("Using IOSP {}", (Object)spi.getClass().getName());
        }
        NetcdfFile ncfile = spi.isBuilder() ? NetcdfFiles.build(spi, raf, location, cancelTask) : new NetcdfFile(spi, raf, location, cancelTask);
        spi.buildFinish(ncfile);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return ncfile;
    }

    @Nullable
    private static IOServiceProvider getIosp(RandomAccessFile raf) throws IOException {
        if (NetcdfFile.debugSPI) {
            log.info("NetcdfFile try to open = {}", (Object)raf.getLocation());
        }
        for (IOServiceProvider registeredSpi : registeredProviders) {
            if (NetcdfFile.debugSPI) {
                log.info(" try iosp = {}", (Object)registeredSpi.getClass().getName());
            }
            if (!registeredSpi.isValidFile(raf)) continue;
            Class<?> c = registeredSpi.getClass();
            try {
                return (IOServiceProvider)c.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
            }
        }
        if (N3headerNew.isValidFile(raf)) {
            return new N3iospNew();
        }
        for (IOServiceProvider loadedSpi : ServiceLoader.load(IOServiceProvider.class)) {
            if (!loadedSpi.isValidFile(raf)) continue;
            Class<?> c = loadedSpi.getClass();
            try {
                return (IOServiceProvider)c.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
            }
        }
        return null;
    }

    private static NetcdfFile build(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
        Object builder = ((NetcdfFile.Builder)NetcdfFile.builder().setIosp((AbstractIOServiceProvider)spi)).setLocation(location);
        try {
            String title;
            Group.Builder root = Group.builder().setName("");
            spi.build(raf, root, cancelTask);
            ((NetcdfFile.Builder)builder).setRootGroup(root);
            String id = root.getAttributeContainer().findAttributeString("_Id", null);
            if (id != null) {
                ((NetcdfFile.Builder)builder).setId(id);
            }
            if ((title = root.getAttributeContainer().findAttributeString("_Title", null)) != null) {
                ((NetcdfFile.Builder)builder).setTitle(title);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            try {
                spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(t);
        }
        return ((NetcdfFile.Builder)builder).build();
    }

    public static String makeValidCdmObjectName(String shortName) {
        if (shortName == null) {
            return null;
        }
        return StringUtil2.makeValidCdmObjectName(shortName);
    }

    public static String makeValidCDLName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedCdl);
    }

    private static String makeValidPathName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedFullName);
    }

    static String makeValidSectionSpecName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedSectionSpec);
    }

    static String makeNameUnescaped(String vname) {
        return EscapeStrings.backslashUnescape(vname);
    }

    public static String makeFullName(Group g2) {
        Group parent = g2.getParentGroup();
        if (parent == null || parent.isRoot()) {
            return EscapeStrings.backslashEscape(g2.getShortName(), reservedFullName);
        }
        StringBuilder sbuff = new StringBuilder();
        NetcdfFiles.appendGroupName(sbuff, parent, reservedFullName);
        sbuff.append(EscapeStrings.backslashEscape(g2.getShortName(), reservedFullName));
        return sbuff.toString();
    }

    public static String makeFullName(Variable v) {
        return NetcdfFiles.makeFullName(v, reservedFullName);
    }

    public static String makeFullNameSectionSpec(Variable v) {
        return NetcdfFiles.makeFullName(v, reservedSectionSpec);
    }

    private static String makeFullName(Variable node, String reservedChars) {
        Group parent = node.getParentGroup();
        if ((parent == null || parent.isRoot()) && !node.isMemberOfStructure()) {
            return EscapeStrings.backslashEscape(node.getShortName(), reservedChars);
        }
        StringBuilder sbuff = new StringBuilder();
        NetcdfFiles.appendGroupName(sbuff, parent, reservedChars);
        NetcdfFiles.appendStructureName(sbuff, node, reservedChars);
        return sbuff.toString();
    }

    private static void appendGroupName(StringBuilder sbuff, Group g2, String reserved) {
        if (g2 == null) {
            return;
        }
        if (g2.getParentGroup() == null) {
            return;
        }
        NetcdfFiles.appendGroupName(sbuff, g2.getParentGroup(), reserved);
        sbuff.append(EscapeStrings.backslashEscape(g2.getShortName(), reserved));
        sbuff.append("/");
    }

    private static void appendStructureName(StringBuilder sbuff, Variable n, String reserved) {
        if (n.isMemberOfStructure()) {
            NetcdfFiles.appendStructureName(sbuff, n.getParentStructure(), reserved);
            sbuff.append(".");
        }
        sbuff.append(EscapeStrings.backslashEscape(n.getShortName(), reserved));
    }

    protected static String makeFullNameWithString(Group parent, String name) {
        name = NetcdfFiles.makeValidPathName(name);
        StringBuilder sbuff = new StringBuilder();
        NetcdfFiles.appendGroupName(sbuff, parent, null);
        sbuff.append(name);
        return sbuff.toString();
    }

    static {
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            log = LoggerFactory.getLogger(NetcdfFile.class);
                            registeredProviders = new ArrayList<IOServiceProvider>();
                            registeredRandomAccessFileProviders = new ArrayList<RandomAccessFileProvider>();
                            stringLocker = new StringLocker();
                            possibleCompressedSuffixes = Arrays.asList("Z", "zip", "gzip", "gz", "bz2");
                            loadWarnings = false;
                            RC.initialize();
                            try {
                                NetcdfFiles.registerIOProvider("ucar.nc2.internal.iosp.hdf5.H5iospNew");
                            }
                            catch (Throwable e) {
                                if (!loadWarnings) break block10;
                                log.info("Cant load class H5iosp", e);
                            }
                        }
                        try {
                            NetcdfFiles.registerIOProvider("ucar.nc2.stream.NcStreamIosp");
                        }
                        catch (Throwable e) {
                            if (!loadWarnings) break block11;
                            log.info("Cant load class NcStreamIosp", e);
                        }
                    }
                    try {
                        NetcdfFiles.registerIOProvider("ucar.nc2.internal.iosp.hdf4.H4iosp");
                    }
                    catch (Throwable e) {
                        if (!loadWarnings) break block12;
                        log.info("Cant load class H4iosp", e);
                    }
                }
                try {
                    NetcdfFiles.registerRandomAccessFileProvider("ucar.unidata.io.http.HTTPRandomAccessFile$Provider");
                }
                catch (Throwable e) {
                    if (!loadWarnings) break block13;
                    log.info("Cant load class HTTPRandomAccessFileProvider", e);
                }
            }
            try {
                NetcdfFiles.registerRandomAccessFileProvider("ucar.unidata.io.InMemoryRandomAccessFile$Provider");
            }
            catch (Throwable e) {
                if (!loadWarnings) break block14;
                log.info("Cant load class InMemoryRandomAccessFileProvider", e);
            }
        }
        userLoads = true;
    }
}

