/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.utils.HalfOpenRectangle;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.distance.DiscreteFrechetDistance;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class GeomUtils {
    public static String printGeom(Geometry geom) {
        if (geom.getUserData() != null) {
            return geom.toText() + "\t" + geom.getUserData();
        }
        return geom.toText();
    }

    public static String printGeom(Object geom) {
        Geometry g2 = (Geometry)geom;
        return GeomUtils.printGeom(g2);
    }

    public static int hashCode(Geometry geom) {
        return geom.getUserData() == null ? geom.hashCode() : geom.hashCode() * 31 + geom.getUserData().hashCode();
    }

    public static boolean equalsTopoGeom(Geometry geom1, Geometry geom2) {
        if (Objects.equals(geom1.getUserData(), geom2.getUserData())) {
            return geom1.equals(geom2);
        }
        return false;
    }

    public static boolean equalsExactGeom(Geometry geom1, Object geom2) {
        if (!(geom2 instanceof Geometry)) {
            return false;
        }
        Geometry g2 = (Geometry)geom2;
        if (Objects.equals(geom1.getUserData(), g2.getUserData())) {
            return geom1.equalsExact(g2);
        }
        return false;
    }

    public static boolean equalsExactGeomUnsortedUserData(Geometry geom1, Object geom2) {
        if (!(geom2 instanceof Geometry)) {
            return false;
        }
        Geometry g2 = (Geometry)geom2;
        if (GeomUtils.equalsUserData(geom1.getUserData(), g2.getUserData())) {
            return geom1.equalsExact(g2);
        }
        return false;
    }

    public static boolean equalsUserData(Object userData1, Object userData2) {
        Object[] split1 = ((String)userData1).split("\t");
        Object[] split2 = ((String)userData2).split("\t");
        Arrays.sort(split1);
        Arrays.sort(split2);
        return Arrays.equals(split1, split2);
    }

    public static void flipCoordinates(Geometry g2) {
        g2.apply(new CoordinateSequenceFilter(){

            @Override
            public void filter(CoordinateSequence seq, int i) {
                double oldX = seq.getCoordinate((int)i).x;
                double oldY = seq.getCoordinateCopy((int)i).y;
                seq.getCoordinate(i).setX(oldY);
                seq.getCoordinate(i).setY(oldX);
            }

            @Override
            public boolean isGeometryChanged() {
                return true;
            }

            @Override
            public boolean isDone() {
                return false;
            }
        });
    }

    public static Geometry getInteriorPoint(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return geometry.getInteriorPoint();
    }

    public static Geometry getNthPoint(LineString lineString, int n) {
        if (lineString == null || n == 0) {
            return null;
        }
        int p = lineString.getNumPoints();
        if (Math.abs(n) > p) {
            return null;
        }
        Coordinate coordinate = n > 0 ? lineString.getCoordinates()[n - 1] : lineString.getCoordinates()[p + n];
        return lineString.getFactory().createPoint(coordinate);
    }

    public static Geometry getExteriorRing(Geometry geometry) {
        try {
            Polygon polygon = (Polygon)geometry;
            return polygon.getExteriorRing();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static String getEWKT(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        int srid = geometry.getSRID();
        String sridString = "";
        if (srid != 0) {
            sridString = "SRID=" + String.valueOf(srid) + ";";
        }
        return sridString + new WKTWriter(4).write(geometry);
    }

    public static String getWKT(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return new WKTWriter(4).write(geometry);
    }

    public static String getHexEWKB(Geometry geometry, int endian) {
        WKBWriter writer = new WKBWriter(GeomUtils.getDimension(geometry), endian, geometry.getSRID() != 0);
        return WKBWriter.toHex(writer.write(geometry));
    }

    public static byte[] getEWKB(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        int endian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? 1 : 2;
        WKBWriter writer = new WKBWriter(GeomUtils.getDimension(geometry), endian, geometry.getSRID() != 0);
        return writer.write(geometry);
    }

    public static byte[] getWKB(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        int endian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? 1 : 2;
        WKBWriter writer = new WKBWriter(GeomUtils.getDimension(geometry), endian, false);
        return writer.write(geometry);
    }

    public static Geometry get2dGeom(Geometry geom) {
        Coordinate[] coordinates = geom.getCoordinates();
        GeometryFactory geometryFactory = geom.getFactory();
        CoordinateSequence sequence = geometryFactory.getCoordinateSequenceFactory().create(coordinates);
        if (sequence.getDimension() > 2) {
            int i;
            for (i = 0; i < coordinates.length; ++i) {
                sequence.setOrdinate(i, 2, Double.NaN);
            }
            if (sequence.getDimension() == 4) {
                for (i = 0; i < coordinates.length; ++i) {
                    sequence.setOrdinate(i, 3, Double.NaN);
                }
            }
        }
        geom.geometryChanged();
        return geom;
    }

    public static Geometry buildArea(Geometry geom) {
        if (geom == null || geom.isEmpty()) {
            return geom;
        }
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(geom);
        List polygons = (List)polygonizer.getPolygons();
        if (polygons.isEmpty()) {
            return null;
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        int srid = geom.getSRID();
        Map<Polygon, Polygon> parentMap = GeomUtils.findFaceHoles(polygons);
        ArrayList<Polygon> facesWithEvenAncestors = new ArrayList<Polygon>();
        for (Polygon face : polygons) {
            face.normalize();
            if (GeomUtils.countParents(parentMap, face) % 2 != 0) continue;
            facesWithEvenAncestors.add(face);
        }
        UnaryUnionOp unaryUnionOp = new UnaryUnionOp(facesWithEvenAncestors);
        Geometry outputGeom = unaryUnionOp.union();
        if (outputGeom != null) {
            outputGeom.normalize();
            if (outputGeom.getSRID() != srid) {
                outputGeom = Functions.setSRID(outputGeom, srid);
            }
        }
        return outputGeom;
    }

    public static int getDimension(Geometry geometry) {
        return geometry.getCoordinate() != null && !Double.isNaN(geometry.getCoordinate().getZ()) ? 3 : 2;
    }

    public static boolean geometryIsHomogeneous(Geometry geometry) {
        int dimension = geometry.getDimension();
        if (!geometry.isEmpty()) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                if (dimension == geometry.getGeometryN(i).getDimension()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean geometryIsPuntal(Geometry geometry) {
        if (geometry instanceof Puntal) {
            return true;
        }
        return GeomUtils.geometryIsHomogeneous(geometry) && geometry.getDimension() == 0;
    }

    public static boolean geometryIsLineal(Geometry geometry) {
        if (geometry instanceof Lineal) {
            return true;
        }
        return GeomUtils.geometryIsHomogeneous(geometry) && geometry.getDimension() == 1;
    }

    public static boolean geometryIsPolygonal(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            return true;
        }
        return GeomUtils.geometryIsHomogeneous(geometry) && geometry.getDimension() == 2;
    }

    public static boolean isDuplicate(Geometry left, Geometry right, HalfOpenRectangle extent) {
        Point referencePoint;
        if (left instanceof Point || right instanceof Point) {
            return false;
        }
        Envelope intersection = left.getEnvelopeInternal().intersection(right.getEnvelopeInternal());
        return !intersection.isNull() && !extent.contains(referencePoint = left.getFactory().createPoint(new Coordinate(intersection.getMinX(), intersection.getMinY())));
    }

    private static Map<Polygon, Polygon> findFaceHoles(List<Polygon> faces) {
        HashMap<Polygon, Polygon> parentMap = new HashMap<Polygon, Polygon>();
        faces.sort(Comparator.comparing(p -> p.getEnvelope().getArea()).reversed());
        for (int i = 0; i < faces.size(); ++i) {
            Polygon face = faces.get(i);
            int nHoles = face.getNumInteriorRing();
            for (int h2 = 0; h2 < nHoles; ++h2) {
                LinearRing hole = face.getInteriorRingN(h2);
                for (int j = i + 1; j < faces.size(); ++j) {
                    LinearRing face2ExteriorRing;
                    Polygon face2 = faces.get(j);
                    if (parentMap.containsKey(face2) || !(face2ExteriorRing = face2.getExteriorRing()).equals(hole)) continue;
                    parentMap.put(face2, face);
                }
            }
        }
        return parentMap;
    }

    private static int countParents(Map<Polygon, Polygon> parentMap, Polygon face) {
        int pCount = 0;
        while (parentMap.containsKey(face)) {
            ++pCount;
            face = parentMap.get(face);
        }
        return pCount;
    }

    public static <T extends Geometry> List<Geometry> extractGeometryCollection(Geometry geom, Class<T> geomType) {
        ArrayList<Geometry> leafs = new ArrayList<Geometry>();
        if (!(geom instanceof GeometryCollection)) {
            if (geomType.isAssignableFrom(geom.getClass())) {
                leafs.add(geom);
            }
            return leafs;
        }
        LinkedList<GeometryCollection> parents = new LinkedList<GeometryCollection>();
        parents.add((GeometryCollection)geom);
        while (!parents.isEmpty()) {
            GeometryCollection parent = (GeometryCollection)parents.removeFirst();
            for (int i = 0; i < parent.getNumGeometries(); ++i) {
                Geometry child = parent.getGeometryN(i);
                if (child instanceof GeometryCollection) {
                    parents.add((GeometryCollection)child);
                    continue;
                }
                if (!geomType.isAssignableFrom(child.getClass())) continue;
                leafs.add(child);
            }
        }
        return leafs;
    }

    public static List<Geometry> extractGeometryCollection(Geometry geom) {
        return GeomUtils.extractGeometryCollection(geom, Geometry.class);
    }

    public static Geometry[] getSubGeometries(Geometry geom) {
        Geometry[] geometries = new Geometry[geom.getNumGeometries()];
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            geometries[i] = geom.getGeometryN(i);
        }
        return geometries;
    }

    public static int getPolygonNumRings(Polygon polygon) {
        LinearRing shell = polygon.getExteriorRing();
        if (shell == null || shell.isEmpty()) {
            return 0;
        }
        return 1 + polygon.getNumInteriorRing();
    }

    public static void translateGeom(Geometry geometry, double deltaX, double deltaY, double deltaZ) {
        Coordinate[] coordinates = geometry.getCoordinates();
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate currCoordinate = coordinates[i];
            currCoordinate.setX(currCoordinate.getX() + deltaX);
            currCoordinate.setY(currCoordinate.getY() + deltaY);
            if (Double.isNaN(currCoordinate.z)) continue;
            currCoordinate.setZ(currCoordinate.getZ() + deltaZ);
        }
        if (deltaX != 0.0 || deltaY != 0.0 || deltaZ != 0.0) {
            geometry.geometryChanged();
        }
    }

    public static boolean isAnyGeomEmpty(Geometry ... geometries) {
        for (Geometry geometry : geometries) {
            if (geometry == null || !geometry.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Coordinate[] getStartEndCoordinates(Geometry line) {
        if (line.getNumPoints() < 2) {
            return null;
        }
        Coordinate[] coordinates = line.getCoordinates();
        return new Coordinate[]{coordinates[0], coordinates[coordinates.length - 1]};
    }

    public static double calcAngle(Coordinate start1, Coordinate end1, Coordinate start2, Coordinate end2) {
        double angle1 = GeomUtils.normalizeAngle(Angle.angle(start1, end1));
        double angle2 = GeomUtils.normalizeAngle(Angle.angle(start2, end2));
        return GeomUtils.normalizeAngle(angle1 - angle2);
    }

    private static double normalizeAngle(double angle) {
        if (angle < 0.0) {
            return Math.PI * 2 - Math.abs(angle);
        }
        return angle;
    }

    public static double toDegrees(double angleInRadian) {
        return Angle.toDegrees(angleInRadian);
    }

    public static void affineGeom(Geometry geometry, Double a, Double b, Double c, Double d, Double e, Double f, Double g2, Double h2, Double i, Double xOff, Double yOff, Double zOff) {
        Coordinate[] coordinates;
        for (Coordinate currCoordinate : coordinates = geometry.getCoordinates()) {
            double x = currCoordinate.getX();
            double y = currCoordinate.getY();
            double z = Double.isNaN(currCoordinate.getZ()) ? 0.0 : currCoordinate.getZ();
            double newX = a * x + b * y + xOff;
            if (c != null) {
                newX += c * z;
            }
            double newY = d * x + e * y + yOff;
            if (f != null) {
                newY += f * z;
            }
            currCoordinate.setX(newX);
            currCoordinate.setY(newY);
            if (g2 == null || h2 == null || i == null || Double.isNaN(currCoordinate.getZ())) continue;
            double newZ = g2 * x + h2 * y + i * z + zOff;
            currCoordinate.setZ(newZ);
        }
        geometry.geometryChanged();
    }

    public static double getFrechetDistance(Geometry g1, Geometry g2) {
        if (g1.isEmpty() || g2.isEmpty()) {
            return 0.0;
        }
        return DiscreteFrechetDistance.distance(g1, g2);
    }

    public static Double getHausdorffDistance(Geometry g1, Geometry g2, double densityFrac) {
        if (g1.isEmpty() || g2.isEmpty()) {
            return 0.0;
        }
        DiscreteHausdorffDistance hausdorffDistanceObj = new DiscreteHausdorffDistance(g1, g2);
        if (densityFrac != -1.0) {
            hausdorffDistanceObj.setDensifyFraction(densityFrac);
        }
        return hausdorffDistanceObj.distance();
    }

    public static Geometry addMeasure(Geometry geom, double measure_start, double measure_end) {
        if (!(geom instanceof LineString) && !(geom instanceof MultiLineString)) {
            throw new IllegalArgumentException("Geometry must be a LineString or MultiLineString.");
        }
        if (geom instanceof LineString) {
            return GeomUtils.addMeasure((LineString)geom, measure_start, measure_end);
        }
        return GeomUtils.addMeasure((MultiLineString)geom, measure_start, measure_end);
    }

    private static Geometry addMeasure(LineString geom, double measureStart, double measureEnd) {
        Coordinate[] coordinates = geom.getCoordinates();
        double totalLength = geom.getLength();
        CoordinateList newCoordinates = new CoordinateList();
        Coordinate c1 = coordinates[0];
        double measureRange = measureEnd - measureStart;
        int numCoordinates = coordinates.length;
        for (int i = 0; i < numCoordinates; ++i) {
            Coordinate c2 = coordinates[i];
            double length = c1.distance(c2);
            double measure = totalLength > 0.0 ? measureStart + measureRange * (length / totalLength) : (totalLength == 0.0 && numCoordinates > 1 ? measureStart + measureRange * (double)i / (double)(numCoordinates - 1) : 0.0);
            CoordinateXYZM newCoordinate = new CoordinateXYZM(c2.getX(), c2.getY(), c2.getZ(), measure);
            newCoordinates.add(newCoordinate);
        }
        return geom.getFactory().createLineString(newCoordinates.toCoordinateArray());
    }

    private static Geometry addMeasure(MultiLineString geom, double measureStart, double measureEnd) {
        double totalLength = 0.0;
        double measureRange = measureEnd - measureStart;
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            LineString linestring = (LineString)geom.getGeometryN(i);
            if (linestring.getCoordinates().length <= 1) continue;
            totalLength += linestring.getLength();
        }
        LineString[] newLineStrings = new LineString[geom.getNumGeometries()];
        double length = 0.0;
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            double subLength = 0.0;
            LineString lineString = (LineString)geom.getGeometryN(i);
            if (lineString.getCoordinates().length > 1) {
                subLength = lineString.getCoordinates().length;
            }
            double subMeasureStart = measureStart + measureRange * length / totalLength;
            double subMeasureEnd = measureStart + measureRange * (length + subLength) / totalLength;
            newLineStrings[i] = (LineString)GeomUtils.addMeasure(lineString, subMeasureStart, subMeasureEnd);
            length += subLength;
        }
        return geom.getFactory().createMultiLineString(newLineStrings);
    }

    public static Boolean isMeasuredGeometry(Geometry geom) {
        Coordinate coordinate = geom.getCoordinate();
        return !Double.isNaN(coordinate.getM());
    }

    public static Geometry antiMeridianSafeGeom(Geometry geom) {
        try {
            JtsGeometry jtsGeom = new JtsGeometry(geom, JtsSpatialContext.GEO, true, true);
            return jtsGeom.getGeom();
        }
        catch (TopologyException e) {
            return geom;
        }
    }
}

