/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.math.MathUtil;

class CornerArea {
    public static final double DEFAULT_SMOOTH_WEIGHT = 0.0;
    private double smoothWeight = 0.0;

    public CornerArea() {
    }

    public CornerArea(double smoothWeight) {
        this.smoothWeight = smoothWeight;
    }

    public double area(Coordinate pp, Coordinate p, Coordinate pn) {
        double area = Triangle.area(pp, p, pn);
        double ang = CornerArea.angleNorm(pp, p, pn);
        double angBias = 1.0 - 2.0 * ang;
        double areaWeighted = (1.0 - this.smoothWeight * angBias) * area;
        return areaWeighted;
    }

    private static double angleNorm(Coordinate pp, Coordinate p, Coordinate pn) {
        double angNorm = Angle.angleBetween(pp, p, pn) / 2.0 / Math.PI;
        return MathUtil.clamp(angNorm, 0.0, 1.0);
    }
}

