/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import javax.annotation.Nullable;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.time.Calendar;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

class CoardsConventions
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "COARDS";
    protected boolean checkForMeter = true;

    CoardsConventions(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    boolean checkTimeVarForCalendar(VariableDS.Builder vb) {
        Attribute calAttr;
        boolean hasChanged = false;
        String unit = vb.getUnits();
        if (unit != null && SimpleUnit.isDateUnit(unit = unit.trim()) && (calAttr = vb.getAttributeContainer().findAttributeIgnoreCase("calendar")) == null) {
            calAttr = new Attribute("calendar", Calendar.gregorian.toString());
            vb.addAttribute(calAttr);
            hasChanged = true;
        }
        return hasChanged;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        for (Variable.Builder<?> vb : this.rootGroup.vbuilders) {
            if (!(vb instanceof VariableDS.Builder)) continue;
            this.checkTimeVarForCalendar((VariableDS.Builder)vb);
        }
    }

    @Override
    @Nullable
    protected AxisType getAxisType(VariableDS.Builder vb) {
        String unit = vb.getUnits();
        if (unit == null) {
            return null;
        }
        if ((unit = unit.trim()).equalsIgnoreCase("degrees_east") || unit.equalsIgnoreCase("degrees_E") || unit.equalsIgnoreCase("degreesE") || unit.equalsIgnoreCase("degree_east") || unit.equalsIgnoreCase("degree_E") || unit.equalsIgnoreCase("degreeE")) {
            return AxisType.Lon;
        }
        if (unit.equalsIgnoreCase("degrees_north") || unit.equalsIgnoreCase("degrees_N") || unit.equalsIgnoreCase("degreesN") || unit.equalsIgnoreCase("degree_north") || unit.equalsIgnoreCase("degree_N") || unit.equalsIgnoreCase("degreeN")) {
            return AxisType.Lat;
        }
        if (SimpleUnit.isDateUnit(unit)) {
            return AxisType.Time;
        }
        if (SimpleUnit.isCompatible("mbar", unit)) {
            return AxisType.Pressure;
        }
        if (unit.equalsIgnoreCase("level") || unit.equalsIgnoreCase("layer") || unit.equalsIgnoreCase("sigma_level")) {
            return AxisType.GeoZ;
        }
        String positive = vb.getAttributeContainer().findAttributeString("positive", null);
        if (positive != null) {
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
            return AxisType.GeoZ;
        }
        return null;
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return CoardsConventions.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new CoardsConventions(datasetBuilder);
        }
    }
}

