/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance.metadata.proxy;

import com.google.common.base.Joiner;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.util.IpUtils;

public final class ProxyInstanceMetaData
implements InstanceMetaData {
    private static final String DELIMITER = "@";
    private final String id;
    private final String ip;
    private final int port;
    private final String version;

    public ProxyInstanceMetaData(String id, int port) {
        this.id = id;
        this.ip = IpUtils.getIp();
        this.port = port;
        this.version = "5.5.1";
    }

    public ProxyInstanceMetaData(String id, String attributes, String version) {
        this.id = id;
        String[] attributesList = attributes.split(DELIMITER);
        this.ip = attributesList[0];
        this.port = Integer.parseInt(attributesList[1]);
        this.version = version;
    }

    @Override
    public InstanceType getType() {
        return InstanceType.PROXY;
    }

    @Override
    public String getAttributes() {
        return Joiner.on((String)DELIMITER).join((Object)this.ip, (Object)this.port, new Object[0]);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }
}

