/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.impl;

import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.determiner.HintShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.shadow.spi.hint.HintShadowAlgorithm;

public final class ShadowNonDMLStatementRoutingEngine
implements ShadowRouteEngine {
    private final HintValueContext hintValueContext;

    @Override
    public void route(RouteContext routeContext, ShadowRule rule) {
        this.decorateRouteContext(routeContext, rule, this.findShadowDataSourceMappings(rule));
    }

    private Map<String, String> findShadowDataSourceMappings(ShadowRule rule) {
        if (!this.hintValueContext.isShadow()) {
            return Collections.emptyMap();
        }
        if (this.isMatchAnyNoteShadowAlgorithms(rule, new ShadowDetermineCondition("", ShadowOperationType.HINT_MATCH))) {
            return rule.getAllShadowDataSourceMappings();
        }
        return Collections.emptyMap();
    }

    private boolean isMatchAnyNoteShadowAlgorithms(ShadowRule rule, ShadowDetermineCondition shadowCondition) {
        for (HintShadowAlgorithm<Comparable<?>> each : rule.getAllHintShadowAlgorithms()) {
            if (!HintShadowAlgorithmDeterminer.isShadow(each, shadowCondition, rule, this.hintValueContext.isShadow())) continue;
            return true;
        }
        return false;
    }

    @Generated
    public ShadowNonDMLStatementRoutingEngine(HintValueContext hintValueContext) {
        this.hintValueContext = hintValueContext;
    }
}

