/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.type;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class DatabaseTypeRegistry {
    private static final Map<DatabaseType, DialectDatabaseMetaData> REGISTERED_META_DATA = new ConcurrentHashMap<DatabaseType, DialectDatabaseMetaData>();
    private final DatabaseType databaseType;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public DatabaseTypeRegistry(DatabaseType databaseType) {
        this.databaseType = databaseType;
        if (!REGISTERED_META_DATA.containsKey(databaseType)) {
            REGISTERED_META_DATA.put(databaseType, DatabaseTypedSPILoader.getService(DialectDatabaseMetaData.class, databaseType));
        }
        this.dialectDatabaseMetaData = REGISTERED_META_DATA.get(databaseType);
    }

    public Collection<DatabaseType> getAllBranchDatabaseTypes() {
        return ShardingSphereServiceLoader.getServiceInstances(DatabaseType.class).stream().filter(each -> each.getTrunkDatabaseType().map(optional -> optional == this.databaseType).orElse(false)).collect(Collectors.toList());
    }

    public String getDefaultSchemaName(String databaseName) {
        return this.dialectDatabaseMetaData.getDefaultSchema().orElseGet(() -> null == databaseName ? null : databaseName.toLowerCase());
    }

    @Generated
    public DialectDatabaseMetaData getDialectDatabaseMetaData() {
        return this.dialectDatabaseMetaData;
    }
}

