/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.check.consistency;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.ConsistencyCheckJobItemProgressContext;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.PipelineCancellable;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.PipelineDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyCheckerFactory;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryCheckParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datanode.DataNodeUtils;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.data.PipelineTableDataConsistencyCheckLoadingFailedException;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.data.pipeline.core.job.service.TransmissionJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataUtils;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.StandardPipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobType;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveQualifiedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationDataConsistencyChecker
implements PipelineDataConsistencyChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationDataConsistencyChecker.class);
    private final MigrationJobConfiguration jobConfig;
    private final JobRateLimitAlgorithm readRateLimitAlgorithm;
    private final ConsistencyCheckJobItemProgressContext progressContext;
    private final AtomicReference<TableInventoryChecker> currentTableInventoryChecker = new AtomicReference();
    private final AtomicBoolean canceling = new AtomicBoolean(false);

    public MigrationDataConsistencyChecker(MigrationJobConfiguration jobConfig, TransmissionProcessContext processContext, ConsistencyCheckJobItemProgressContext progressContext) {
        this.jobConfig = jobConfig;
        this.readRateLimitAlgorithm = null == processContext ? null : processContext.getReadRateLimitAlgorithm();
        this.progressContext = progressContext;
    }

    public Map<String, TableDataConsistencyCheckResult> check(String algorithmType, Properties algorithmProps) {
        LinkedList sourceTableNames = new LinkedList();
        this.jobConfig.getJobShardingDataNodes().forEach(each -> each.getEntries().forEach(entry -> entry.getDataNodes().forEach(dataNode -> sourceTableNames.add(DataNodeUtils.formatWithSchema((DataNode)dataNode)))));
        this.progressContext.setRecordsCount(this.getRecordsCount());
        this.progressContext.getTableNames().addAll(sourceTableNames);
        this.progressContext.onProgressUpdated(new PipelineJobUpdateProgress(0));
        LinkedHashMap<CaseInsensitiveQualifiedTable, TableDataConsistencyCheckResult> result = new LinkedHashMap<CaseInsensitiveQualifiedTable, TableDataConsistencyCheckResult>();
        try (PipelineDataSourceManager dataSourceManager = new PipelineDataSourceManager();
             TableDataConsistencyChecker tableChecker = TableDataConsistencyCheckerFactory.newInstance((String)algorithmType, (Properties)algorithmProps);){
            Iterator<JobDataNodeLine> iterator = this.jobConfig.getJobShardingDataNodes().iterator();
            while (true) {
                if (iterator.hasNext()) {
                    JobDataNodeLine each2 = iterator.next();
                    if (!this.checkTableInventoryDataUnmatchedAndBreak(each2, tableChecker, result, dataSourceManager)) continue;
                    Map<String, TableDataConsistencyCheckResult> map = result.entrySet().stream().collect(Collectors.toMap(entry -> ((CaseInsensitiveQualifiedTable)entry.getKey()).toString(), Map.Entry::getValue));
                    return map;
                    continue;
                }
                break;
            }
        }
        return result.entrySet().stream().collect(Collectors.toMap(entry -> ((CaseInsensitiveQualifiedTable)entry.getKey()).toString(), Map.Entry::getValue));
    }

    private long getRecordsCount() {
        Map jobProgress = new TransmissionJobManager((PipelineJobType)new MigrationJobType()).getJobProgress((PipelineJobConfiguration)this.jobConfig);
        return jobProgress.values().stream().filter(Objects::nonNull).mapToLong(TransmissionJobItemProgress::getInventoryRecordsCount).sum();
    }

    private boolean checkTableInventoryDataUnmatchedAndBreak(JobDataNodeLine jobDataNodeLine, TableDataConsistencyChecker tableChecker, Map<CaseInsensitiveQualifiedTable, TableDataConsistencyCheckResult> checkResultMap, PipelineDataSourceManager dataSourceManager) {
        for (JobDataNodeEntry entry : jobDataNodeLine.getEntries()) {
            for (DataNode each : entry.getDataNodes()) {
                TableDataConsistencyCheckResult checkResult = this.checkSingleTableInventoryData(entry.getLogicTableName(), each, tableChecker, dataSourceManager);
                checkResultMap.put(new CaseInsensitiveQualifiedTable(each.getSchemaName(), each.getTableName()), checkResult);
                if (checkResult.isMatched() || !tableChecker.isBreakOnInventoryCheckNotMatched()) continue;
                log.info("Unmatched on table '{}', ignore left tables", (Object)DataNodeUtils.formatWithSchema((DataNode)each));
                return true;
            }
        }
        return false;
    }

    private TableDataConsistencyCheckResult checkSingleTableInventoryData(String targetTableName, DataNode dataNode, TableDataConsistencyChecker tableChecker, PipelineDataSourceManager dataSourceManager) {
        CaseInsensitiveQualifiedTable sourceTable = new CaseInsensitiveQualifiedTable(dataNode.getSchemaName(), dataNode.getTableName());
        CaseInsensitiveQualifiedTable targetTable = new CaseInsensitiveQualifiedTable(dataNode.getSchemaName(), targetTableName);
        PipelineDataSource sourceDataSource = dataSourceManager.getDataSource(this.jobConfig.getSources().get(dataNode.getDataSourceName()));
        PipelineDataSource targetDataSource = dataSourceManager.getDataSource(this.jobConfig.getTarget());
        StandardPipelineTableMetaDataLoader metaDataLoader = new StandardPipelineTableMetaDataLoader(sourceDataSource);
        PipelineTableMetaData tableMetaData = metaDataLoader.getTableMetaData(dataNode.getSchemaName(), dataNode.getTableName());
        ShardingSpherePreconditions.checkNotNull((Object)tableMetaData, () -> new PipelineTableDataConsistencyCheckLoadingFailedException(dataNode.getSchemaName(), dataNode.getTableName()));
        List columnNames = tableMetaData.getColumnNames();
        List uniqueKeys = PipelineTableMetaDataUtils.getUniqueKeyColumns((String)sourceTable.getSchemaName().toString(), (String)sourceTable.getTableName().toString(), (PipelineTableMetaDataLoader)metaDataLoader);
        TableInventoryCheckParameter param = new TableInventoryCheckParameter(this.jobConfig.getJobId(), sourceDataSource, targetDataSource, sourceTable, targetTable, columnNames, uniqueKeys, this.readRateLimitAlgorithm, this.progressContext);
        TableInventoryChecker tableInventoryChecker = tableChecker.buildTableInventoryChecker(param);
        this.currentTableInventoryChecker.set(tableInventoryChecker);
        TableDataConsistencyCheckResult result = tableInventoryChecker.checkSingleTableInventoryData();
        this.currentTableInventoryChecker.set(null);
        return result;
    }

    public void cancel() {
        this.canceling.set(true);
        Optional.ofNullable(this.currentTableInventoryChecker.get()).ifPresent(PipelineCancellable::cancel);
    }

    public boolean isCanceling() {
        return this.canceling.get();
    }
}

