/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.config;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;

public final class MigrationJobConfiguration
implements PipelineJobConfiguration {
    private final String jobId;
    private final String targetDatabaseName;
    private final DatabaseType sourceDatabaseType;
    private final DatabaseType targetDatabaseType;
    private final Map<String, PipelineDataSourceConfiguration> sources;
    private final PipelineDataSourceConfiguration target;
    private final List<String> targetTableNames;
    private final Map<String, String> targetTableSchemaMap;
    private final JobDataNodeLine tablesFirstDataNodes;
    private final List<JobDataNodeLine> jobShardingDataNodes;
    private final int concurrency;
    private final int retryTimes;

    public int getJobShardingCount() {
        return this.jobShardingDataNodes.size();
    }

    public JobDataNodeLine getJobDataNodeLine(int jobShardingItem) {
        return this.jobShardingDataNodes.get(jobShardingItem);
    }

    @Generated
    public MigrationJobConfiguration(String jobId, String targetDatabaseName, DatabaseType sourceDatabaseType, DatabaseType targetDatabaseType, Map<String, PipelineDataSourceConfiguration> sources, PipelineDataSourceConfiguration target, List<String> targetTableNames, Map<String, String> targetTableSchemaMap, JobDataNodeLine tablesFirstDataNodes, List<JobDataNodeLine> jobShardingDataNodes, int concurrency, int retryTimes) {
        this.jobId = jobId;
        this.targetDatabaseName = targetDatabaseName;
        this.sourceDatabaseType = sourceDatabaseType;
        this.targetDatabaseType = targetDatabaseType;
        this.sources = sources;
        this.target = target;
        this.targetTableNames = targetTableNames;
        this.targetTableSchemaMap = targetTableSchemaMap;
        this.tablesFirstDataNodes = tablesFirstDataNodes;
        this.jobShardingDataNodes = jobShardingDataNodes;
        this.concurrency = concurrency;
        this.retryTimes = retryTimes;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getTargetDatabaseName() {
        return this.targetDatabaseName;
    }

    @Generated
    public DatabaseType getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Generated
    public DatabaseType getTargetDatabaseType() {
        return this.targetDatabaseType;
    }

    @Generated
    public Map<String, PipelineDataSourceConfiguration> getSources() {
        return this.sources;
    }

    @Generated
    public PipelineDataSourceConfiguration getTarget() {
        return this.target;
    }

    @Generated
    public List<String> getTargetTableNames() {
        return this.targetTableNames;
    }

    @Generated
    public Map<String, String> getTargetTableSchemaMap() {
        return this.targetTableSchemaMap;
    }

    @Generated
    public JobDataNodeLine getTablesFirstDataNodes() {
        return this.tablesFirstDataNodes;
    }

    @Generated
    public List<JobDataNodeLine> getJobShardingDataNodes() {
        return this.jobShardingDataNodes;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public String toString() {
        return "MigrationJobConfiguration(jobId=" + this.getJobId() + ", targetDatabaseName=" + this.getTargetDatabaseName() + ", sourceDatabaseType=" + this.getSourceDatabaseType() + ", targetDatabaseType=" + this.getTargetDatabaseType() + ", targetTableNames=" + this.getTargetTableNames() + ", targetTableSchemaMap=" + this.getTargetTableSchemaMap() + ", tablesFirstDataNodes=" + this.getTablesFirstDataNodes() + ", jobShardingDataNodes=" + this.getJobShardingDataNodes() + ", concurrency=" + this.getConcurrency() + ", retryTimes=" + this.getRetryTimes() + ")";
    }
}

