/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.context;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.PipelineSink;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.type.PipelineDataSourceSink;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.StandardPipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationTaskConfiguration;

public final class MigrationJobItemContext
implements TransmissionJobItemContext {
    private final String jobId;
    private final int shardingItem;
    private final String dataSourceName;
    private volatile boolean stopping;
    private volatile JobStatus status = JobStatus.RUNNING;
    private final TransmissionJobItemProgress initProgress;
    private final MigrationTaskConfiguration taskConfig;
    private final Collection<PipelineTask> inventoryTasks = new LinkedList<PipelineTask>();
    private final Collection<PipelineTask> incrementalTasks = new LinkedList<PipelineTask>();
    private final AtomicLong processedRecordsCount = new AtomicLong(0L);
    private final AtomicLong inventoryRecordsCount = new AtomicLong(0L);
    private final MigrationJobConfiguration jobConfig;
    private final TransmissionProcessContext jobProcessContext;
    private final PipelineDataSourceManager dataSourceManager;
    private final LazyInitializer<PipelineDataSource> sourceDataSourceLazyInitializer = new LazyInitializer<PipelineDataSource>(){

        protected PipelineDataSource initialize() {
            return MigrationJobItemContext.this.dataSourceManager.getDataSource(MigrationJobItemContext.this.taskConfig.getDumperContext().getCommonContext().getDataSourceConfig());
        }
    };
    private final LazyInitializer<PipelineTableMetaDataLoader> sourceMetaDataLoaderLazyInitializer = new LazyInitializer<PipelineTableMetaDataLoader>(){

        protected PipelineTableMetaDataLoader initialize() throws ConcurrentException {
            return new StandardPipelineTableMetaDataLoader((PipelineDataSource)MigrationJobItemContext.this.sourceDataSourceLazyInitializer.get());
        }
    };

    public MigrationJobItemContext(MigrationJobConfiguration jobConfig, int shardingItem, TransmissionJobItemProgress initProgress, TransmissionProcessContext jobProcessContext, MigrationTaskConfiguration taskConfig, PipelineDataSourceManager dataSourceManager) {
        this.jobConfig = jobConfig;
        this.jobId = jobConfig.getJobId();
        this.shardingItem = shardingItem;
        this.dataSourceName = taskConfig.getDataSourceName();
        this.initProgress = initProgress;
        if (null != initProgress) {
            this.processedRecordsCount.set(initProgress.getProcessedRecordsCount());
            this.inventoryRecordsCount.set(initProgress.getInventoryRecordsCount());
        }
        this.jobProcessContext = jobProcessContext;
        this.taskConfig = taskConfig;
        this.dataSourceManager = dataSourceManager;
    }

    public PipelineDataSource getSourceDataSource() {
        return (PipelineDataSource)this.sourceDataSourceLazyInitializer.get();
    }

    public PipelineTableMetaDataLoader getSourceMetaDataLoader() {
        return (PipelineTableMetaDataLoader)this.sourceMetaDataLoaderLazyInitializer.get();
    }

    public PipelineSink getSink() {
        return new PipelineDataSourceSink(this.taskConfig.getImporterConfig(), this.dataSourceManager);
    }

    public boolean isSourceTargetDatabaseTheSame() {
        return this.jobConfig.getSourceDatabaseType() == this.jobConfig.getTargetDatabaseType();
    }

    public void onProgressUpdated(PipelineJobUpdateProgress updateProgress) {
        this.processedRecordsCount.addAndGet(updateProgress.getProcessedRecordsCount());
        PipelineJobProgressPersistService.notifyPersist((String)this.jobId, (int)this.shardingItem);
    }

    public long getProcessedRecordsCount() {
        return this.processedRecordsCount.get();
    }

    public void updateInventoryRecordsCount(long recordsCount) {
        this.inventoryRecordsCount.addAndGet(recordsCount);
    }

    public long getInventoryRecordsCount() {
        return this.inventoryRecordsCount.get();
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public boolean isStopping() {
        return this.stopping;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public TransmissionJobItemProgress getInitProgress() {
        return this.initProgress;
    }

    @Generated
    public MigrationTaskConfiguration getTaskConfig() {
        return this.taskConfig;
    }

    @Generated
    public Collection<PipelineTask> getInventoryTasks() {
        return this.inventoryTasks;
    }

    @Generated
    public Collection<PipelineTask> getIncrementalTasks() {
        return this.incrementalTasks;
    }

    @Generated
    public MigrationJobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public TransmissionProcessContext getJobProcessContext() {
        return this.jobProcessContext;
    }

    @Generated
    public PipelineDataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    @Generated
    public LazyInitializer<PipelineDataSource> getSourceDataSourceLazyInitializer() {
        return this.sourceDataSourceLazyInitializer;
    }

    @Generated
    public LazyInitializer<PipelineTableMetaDataLoader> getSourceMetaDataLoaderLazyInitializer() {
        return this.sourceMetaDataLoaderLazyInitializer;
    }

    @Generated
    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }
}

