/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.metadata.data.loader.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.data.loader.MetaDataLoaderConnection;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;

public final class SchemaMetaDataLoader {
    private static final String TABLE_TYPE = "TABLE";
    private static final String VIEW_TYPE = "VIEW";
    private static final String SYSTEM_TABLE_TYPE = "SYSTEM TABLE";
    private static final String SYSTEM_VIEW_TYPE = "SYSTEM VIEW";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEME = "TABLE_SCHEM";

    public static Map<String, Collection<String>> loadSchemaTableNames(String databaseName, DatabaseType databaseType, DataSource dataSource, Collection<String> excludedTables) throws SQLException {
        try (MetaDataLoaderConnection connection = new MetaDataLoaderConnection(databaseType, dataSource.getConnection());){
            Collection<String> schemaNames = SchemaMetaDataLoader.loadSchemaNames(connection, databaseType);
            DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
            CaseInsensitiveMap result = new CaseInsensitiveMap(schemaNames.size(), 1.0f);
            for (String each : schemaNames) {
                String schemaName = dialectDatabaseMetaData.getDefaultSchema().isPresent() ? each : databaseName;
                result.put(schemaName, SchemaMetaDataLoader.loadTableNames(connection, each, excludedTables));
            }
            CaseInsensitiveMap caseInsensitiveMap = result;
            return caseInsensitiveMap;
        }
    }

    public static Collection<String> loadSchemaNames(Connection connection, DatabaseType databaseType) throws SQLException {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        if (!dialectDatabaseMetaData.getDefaultSchema().isPresent()) {
            return Collections.singletonList(connection.getSchema());
        }
        LinkedList<String> result = new LinkedList<String>();
        SystemDatabase systemDatabase = new SystemDatabase(databaseType);
        try (ResultSet resultSet = connection.getMetaData().getSchemas();){
            while (resultSet.next()) {
                String schema = resultSet.getString(TABLE_SCHEME);
                if (systemDatabase.getSystemSchemas().contains(schema)) continue;
                result.add(schema);
            }
        }
        return result.isEmpty() ? Collections.singletonList(connection.getSchema()) : result;
    }

    private static Collection<String> loadTableNames(Connection connection, String schemaName, Collection<String> excludedTables) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), schemaName, null, new String[]{TABLE_TYPE, VIEW_TYPE, SYSTEM_TABLE_TYPE, SYSTEM_VIEW_TYPE});){
            while (resultSet.next()) {
                String table = resultSet.getString(TABLE_NAME);
                if (SchemaMetaDataLoader.isSystemTable(table) || excludedTables.contains(table)) continue;
                result.add(table);
            }
        }
        return result;
    }

    private static boolean isSystemTable(String table) {
        return table.contains("$") || table.contains("/") || table.contains("##");
    }

    @Generated
    private SchemaMetaDataLoader() {
    }
}

