/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import java.util.concurrent.ExecutorService;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.elasticjob.infra.concurrent.ElasticJobExecutorService;
import org.apache.shardingsphere.elasticjob.infra.handler.threadpool.JobExecutorServiceHandler;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;

public final class ShardingTotalCountUsageJobExecutorServiceHandler
implements JobExecutorServiceHandler {
    public static final String TYPE = "SHARDING_TOTAL_COUNT";

    public ExecutorService createExecutorService(String jobName) {
        int poolSize;
        try {
            JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO(jobName);
            poolSize = jobConfigPOJO.getShardingTotalCount();
        }
        catch (RuntimeException ignored) {
            poolSize = Runtime.getRuntime().availableProcessors() * 4;
        }
        return new ElasticJobExecutorService("elasticjob-" + jobName, poolSize).createExecutorService();
    }

    public String getType() {
        return TYPE;
    }
}

