/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.route;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.route.DecorateSQLRouter;
import org.apache.shardingsphere.infra.route.EntranceSQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.single.route.engine.SingleRouteEngineFactory;
import org.apache.shardingsphere.single.route.validator.SingleMetaDataValidatorFactory;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;

public final class SingleSQLRouter
implements EntranceSQLRouter<SingleRule>,
DecorateSQLRouter<SingleRule> {
    public RouteContext createRouteContext(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, SingleRule rule, ConfigurationProperties props) {
        if (1 == database.getResourceMetaData().getStorageUnits().size()) {
            return this.createSingleDataSourceRouteContext(rule, database, queryContext);
        }
        RouteContext result = new RouteContext();
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SingleMetaDataValidatorFactory.newInstance(sqlStatementContext.getSqlStatement()).ifPresent(optional -> optional.validate(rule, sqlStatementContext, database));
        Collection<QualifiedTable> singleTables = this.getSingleTables(database, rule, result, sqlStatementContext);
        SingleRouteEngineFactory.newInstance(singleTables, sqlStatementContext.getSqlStatement(), queryContext.getHintValueContext()).ifPresent(optional -> optional.route(result, rule));
        return result;
    }

    private Collection<QualifiedTable> getSingleTables(ShardingSphereDatabase database, SingleRule rule, RouteContext routeContext, SQLStatementContext sqlStatementContext) {
        Collection<QualifiedTable> qualifiedTables = rule.getQualifiedTables(sqlStatementContext, database);
        return routeContext.getRouteUnits().isEmpty() && sqlStatementContext.getSqlStatement() instanceof CreateTableStatement ? qualifiedTables : rule.getSingleTables(qualifiedTables);
    }

    public void decorateRouteContext(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, SingleRule rule, ConfigurationProperties props) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        Collection<QualifiedTable> singleTables = this.getSingleTables(database, rule, routeContext, sqlStatementContext);
        SingleRouteEngineFactory.newInstance(singleTables, sqlStatementContext.getSqlStatement(), queryContext.getHintValueContext()).ifPresent(optional -> optional.route(routeContext, rule));
    }

    private RouteContext createSingleDataSourceRouteContext(SingleRule rule, ShardingSphereDatabase database, QueryContext queryContext) {
        String logicDataSource = rule.getDataSourceNames().iterator().next();
        String actualDataSource = (String)database.getResourceMetaData().getStorageUnits().keySet().iterator().next();
        RouteContext result = new RouteContext();
        List<String> tableNames = queryContext.getSqlStatementContext() instanceof TableAvailable ? ((TableAvailable)queryContext.getSqlStatementContext()).getTablesContext().getTableNames() : Collections.emptyList();
        result.getRouteUnits().add(new RouteUnit(new RouteMapper(logicDataSource, actualDataSource), this.createTableMappers(tableNames)));
        return result;
    }

    private Collection<RouteMapper> createTableMappers(Collection<String> tableNames) {
        LinkedList<RouteMapper> result = new LinkedList<RouteMapper>();
        for (String each : tableNames) {
            result.add(new RouteMapper(each, each));
        }
        return result;
    }

    public int getOrder() {
        return 10;
    }

    public Class<SingleRule> getTypeClass() {
        return SingleRule.class;
    }
}

