/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.task;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.importer.Importer;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.finished.IngestFinishedPosition;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.TaskExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.task.progress.InventoryTaskProgress;

public final class CDCInventoryTask
implements PipelineTask {
    private final String taskId;
    private final PipelineExecuteEngine inventoryDumperExecuteEngine;
    private final PipelineExecuteEngine inventoryImporterExecuteEngine;
    private final Dumper dumper;
    @Nullable
    private final Importer importer;
    private final AtomicReference<IngestPosition> position;

    public Collection<CompletableFuture<?>> start() {
        if (this.position.get() instanceof IngestFinishedPosition) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        result.add(this.inventoryDumperExecuteEngine.submit((PipelineLifecycleRunnable)this.dumper, (ExecuteCallback)new TaskExecuteCallback((PipelineTask)this)));
        if (null != this.importer) {
            result.add(this.inventoryImporterExecuteEngine.submit((PipelineLifecycleRunnable)this.importer, (ExecuteCallback)new TaskExecuteCallback((PipelineTask)this)));
        }
        return result;
    }

    public void stop() {
        this.dumper.stop();
        if (null != this.importer) {
            this.importer.stop();
        }
    }

    public InventoryTaskProgress getTaskProgress() {
        return new InventoryTaskProgress(this.position.get());
    }

    public void close() {
    }

    @Generated
    public CDCInventoryTask(String taskId, PipelineExecuteEngine inventoryDumperExecuteEngine, PipelineExecuteEngine inventoryImporterExecuteEngine, Dumper dumper, @Nullable Importer importer, AtomicReference<IngestPosition> position) {
        this.taskId = taskId;
        this.inventoryDumperExecuteEngine = inventoryDumperExecuteEngine;
        this.inventoryImporterExecuteEngine = inventoryImporterExecuteEngine;
        this.dumper = dumper;
        this.importer = importer;
        this.position = position;
    }

    @Generated
    public String toString() {
        return "CDCInventoryTask(taskId=" + this.getTaskId() + ", position=" + this.position + ")";
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }
}

