/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractDataSourceAdapter;
import org.apache.shardingsphere.driver.state.DriverStateContext;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.scope.GlobalRuleConfiguration;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;

public final class ShardingSphereDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private final String databaseName;
    private final ContextManager contextManager;

    public ShardingSphereDataSource(String databaseName, ModeConfiguration modeConfig) throws SQLException {
        this(databaseName, modeConfig, new LinkedHashMap<String, DataSource>(), new LinkedList<RuleConfiguration>(), new Properties());
    }

    public ShardingSphereDataSource(String databaseName, ModeConfiguration modeConfig, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigs, Properties props) throws SQLException {
        this.databaseName = databaseName;
        this.contextManager = this.createContextManager(modeConfig, dataSourceMap, ruleConfigs, null == props ? new Properties() : props);
    }

    private ContextManager createContextManager(ModeConfiguration modeConfig, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigs, Properties props) throws SQLException {
        InstanceMetaData instanceMetaData = ((InstanceMetaDataBuilder)TypedSPILoader.getService(InstanceMetaDataBuilder.class, (Object)"JDBC")).build(-1);
        Collection globalRuleConfigs = ruleConfigs.stream().filter(GlobalRuleConfiguration.class::isInstance).collect(Collectors.toList());
        LinkedList<RuleConfiguration> databaseRuleConfigs = new LinkedList<RuleConfiguration>(ruleConfigs);
        databaseRuleConfigs.removeAll(globalRuleConfigs);
        ContextManagerBuilderParameter param = new ContextManagerBuilderParameter(modeConfig, Collections.singletonMap(this.databaseName, new DataSourceProvidedDatabaseConfiguration(dataSourceMap, databaseRuleConfigs)), Collections.emptyMap(), globalRuleConfigs, props, Collections.emptyList(), instanceMetaData, false);
        return ((ContextManagerBuilder)TypedSPILoader.getService(ContextManagerBuilder.class, (Object)(null == modeConfig ? null : modeConfig.getType()))).build(param, new EventBusContext());
    }

    @Override
    public Connection getConnection() {
        return DriverStateContext.getConnection(this.databaseName, this.contextManager);
    }

    @Override
    public Connection getConnection(String username, String password) {
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        Map storageUnits = this.contextManager.getStorageUnits(this.databaseName);
        return storageUnits.isEmpty() ? 0 : ((StorageUnit)storageUnits.values().iterator().next()).getDataSource().getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        for (StorageUnit each : this.contextManager.getStorageUnits(this.databaseName).values()) {
            each.getDataSource().setLoginTimeout(seconds);
        }
    }

    @Override
    public void close() throws SQLException {
        for (StorageUnit each : this.contextManager.getStorageUnits(this.databaseName).values()) {
            this.close(each.getDataSource());
        }
        this.contextManager.close();
    }

    private void close(DataSource dataSource) throws SQLException {
        if (dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)dataSource)).close();
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }
    }
}

