/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.route.engine.type.broadcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.route.engine.type.BroadcastRouteEngine;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class BroadcastTableBroadcastRoutingEngine
implements BroadcastRouteEngine {
    private final Collection<String> broadcastRuleTableNames;

    @Override
    public RouteContext route(RouteContext routeContext, BroadcastRule broadcastRule) {
        Collection<String> logicTableNames = broadcastRule.getBroadcastRuleTableNames(this.broadcastRuleTableNames);
        if (logicTableNames.isEmpty()) {
            routeContext.getRouteUnits().addAll(this.getRouteContext(broadcastRule).getRouteUnits());
        } else {
            routeContext.getRouteUnits().addAll(this.getRouteContext(broadcastRule, logicTableNames).getRouteUnits());
        }
        return routeContext;
    }

    private RouteContext getRouteContext(BroadcastRule broadcastRule) {
        RouteContext result = new RouteContext();
        for (String each : broadcastRule.getDataSourceNames()) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(each, each), Collections.singletonList(new RouteMapper("", ""))));
        }
        return result;
    }

    private RouteContext getRouteContext(BroadcastRule broadcastRule, Collection<String> logicTableNames) {
        RouteContext result = new RouteContext();
        Collection<RouteMapper> tableRouteMappers = this.getTableRouteMappers(logicTableNames);
        for (String each : broadcastRule.getDataSourceNames()) {
            RouteMapper dataSourceMapper = new RouteMapper(each, each);
            result.getRouteUnits().add(new RouteUnit(dataSourceMapper, tableRouteMappers));
        }
        return result;
    }

    private Collection<RouteMapper> getTableRouteMappers(Collection<String> logicTableNames) {
        ArrayList<RouteMapper> result = new ArrayList<RouteMapper>(logicTableNames.size());
        for (String logicTableName : logicTableNames) {
            result.add(new RouteMapper(logicTableName, logicTableName));
        }
        return result;
    }

    @Generated
    public BroadcastTableBroadcastRoutingEngine(Collection<String> broadcastRuleTableNames) {
        this.broadcastRuleTableNames = broadcastRuleTableNames;
    }
}

