/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm.standard;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithmMetaData;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.apache.shardingsphere.infra.algorithm.cryptographic.core.CryptographicAlgorithm;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class AESEncryptAlgorithm
implements EncryptAlgorithm {
    private final EncryptAlgorithmMetaData metaData = new EncryptAlgorithmMetaData(true, true, false);
    private Properties props;
    private CryptographicAlgorithm cryptographicAlgorithm;

    public void init(Properties props) {
        this.props = props;
        this.cryptographicAlgorithm = (CryptographicAlgorithm)TypedSPILoader.getService(CryptographicAlgorithm.class, (Object)this.getType(), (Properties)props);
    }

    public String encrypt(Object plainValue, AlgorithmSQLContext algorithmSQLContext) {
        Object result = this.cryptographicAlgorithm.encrypt(plainValue);
        return null == result ? null : String.valueOf(result);
    }

    public Object decrypt(Object cipherValue, AlgorithmSQLContext algorithmSQLContext) {
        return this.cryptographicAlgorithm.decrypt(cipherValue);
    }

    public AlgorithmConfiguration toConfiguration() {
        return new AlgorithmConfiguration(this.getType(), this.props);
    }

    public String getType() {
        return "AES";
    }

    @Generated
    public EncryptAlgorithmMetaData getMetaData() {
        return this.metaData;
    }
}

