/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.connection;

import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class ConnectionLimitContext {
    private static final ConnectionLimitContext INSTANCE = new ConnectionLimitContext();
    private final AtomicInteger activeConnections = new AtomicInteger();

    public static ConnectionLimitContext getInstance() {
        return INSTANCE;
    }

    public boolean connectionAllowed() {
        return this.activeConnections.incrementAndGet() <= this.getMaxConnections() || !this.limitsMaxConnections();
    }

    public void connectionInactive() {
        this.activeConnections.decrementAndGet();
    }

    public boolean limitsMaxConnections() {
        return this.getMaxConnections() > 0;
    }

    public int getMaxConnections() {
        return (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_MAX_CONNECTIONS);
    }

    @Generated
    private ConnectionLimitContext() {
    }
}

