/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.PostgreSQLTextValueParser;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.postgresql.jdbc.TimestampUtils;

public final class PostgreSQLTimestampValueParser
implements PostgreSQLTextValueParser<Timestamp> {
    private static final DateTimeFormatter POSTGRESQL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("[yyyy-MM-dd][yyyy_MM_dd][yyyyMMdd][yyyy-M-d][MM/dd/yy][yyMMdd]['T'][ ][HH:mm:ss][HHmmss][HH:mm][HHmm][.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S][ ][XXXXX][XXXX][XXX][XX][X]");

    @Override
    public Timestamp parse(String value) {
        try {
            return Timestamp.valueOf(LocalDateTime.from(POSTGRESQL_DATE_TIME_FORMATTER.parse(value)));
        }
        catch (DateTimeParseException ignored) {
            return PostgreSQLTimestampValueParser.fallbackToPostgreSQLTimestampUtils(value);
        }
    }

    private static Timestamp fallbackToPostgreSQLTimestampUtils(String value) {
        try {
            return new TimestampUtils(false, null).toTimestamp(null, value);
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }
}

