/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.ral.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.handler.executor.ral.plugin.PluginMetaDataQueryResultRow;
import org.apache.shardingsphere.distsql.handler.executor.ral.plugin.PluginTypeAndClassMapper;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowPluginsStatement;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseSupportedTypedSPI;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.PluginNotFoundException;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowPluginsExecutor
implements DistSQLQueryExecutor<ShowPluginsStatement> {
    @Override
    public Collection<String> getColumnNames(ShowPluginsStatement sqlStatement) {
        return this.getColumnNames(this.getPluginClass(sqlStatement));
    }

    private List<String> getColumnNames(Class<? extends TypedSPI> pluginClass) {
        return DatabaseSupportedTypedSPI.class.isAssignableFrom(pluginClass) ? Arrays.asList("type", "type_aliases", "supported_database_types", "description") : Arrays.asList("type", "type_aliases", "description");
    }

    private Class<? extends TypedSPI> getPluginClass(ShowPluginsStatement sqlStatement) {
        return sqlStatement.getPluginClass().isPresent() ? this.getPluginClass((String)sqlStatement.getPluginClass().get()) : ((PluginTypeAndClassMapper)TypedSPILoader.getService(PluginTypeAndClassMapper.class, (Object)sqlStatement.getType())).getPluginClass();
    }

    private Class<? extends TypedSPI> getPluginClass(String pluginClass) {
        try {
            Class<?> result = Class.forName(pluginClass);
            ShardingSpherePreconditions.checkState((boolean)TypedSPI.class.isAssignableFrom(result), () -> new UnsupportedOperationException("The plugin class to be queried must extend TypedSPI."));
            return result;
        }
        catch (ClassNotFoundException ignored) {
            throw new PluginNotFoundException(pluginClass);
        }
    }

    @Override
    public Collection<LocalDataQueryResultRow> getRows(ShowPluginsStatement sqlStatement, ContextManager contextManager) {
        return ShardingSphereServiceLoader.getServiceInstances(this.getPluginClass(sqlStatement)).stream().map(each -> new PluginMetaDataQueryResultRow((TypedSPI)each).toLocalDataQueryResultRow()).collect(Collectors.toList());
    }

    @Override
    public Class<ShowPluginsStatement> getType() {
        return ShowPluginsStatement.class;
    }
}

