/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.LongPointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.MutableLongPointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;

public final class LongLastValueAggregator
implements Aggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public LongLastValueAggregator(Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public LongPointData diff(LongPointData previous, LongPointData current) {
        return current;
    }

    @Override
    public void diffInPlace(LongPointData previousReusablePoint, LongPointData currentPoint) {
        ((MutableLongPointData)previousReusablePoint).set(currentPoint);
    }

    @Override
    public LongPointData toPoint(Measurement measurement) {
        return ImmutableLongPointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public void toPoint(Measurement measurement, LongPointData reusablePoint) {
        ((MutableLongPointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public LongPointData createReusablePoint() {
        return new MutableLongPointData();
    }

    @Override
    public void copyPoint(LongPointData point, LongPointData toReusablePoint) {
        ((MutableLongPointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);
        @Nullable
        private final MutableLongPointData reusablePoint;

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir, MemoryMode memoryMode) {
            super(exemplarReservoir);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableLongPointData() : null;
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            Long value;
            Long l = value = reset ? this.current.getAndSet(DEFAULT_VALUE) : this.current.get();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
                return this.reusablePoint;
            }
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

