/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ingest.inventory;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.DialectInventoryColumnValueReader;
import org.postgresql.util.PGobject;

public final class PostgreSQLInventoryColumnValueReader
implements DialectInventoryColumnValueReader {
    private static final String PG_MONEY_TYPE = "money";
    private static final String PG_BIT_TYPE = "bit";

    public Optional<Object> read(ResultSet resultSet, ResultSetMetaData metaData, int columnIndex) throws SQLException {
        if (this.isMoneyType(metaData, columnIndex)) {
            return Optional.ofNullable(resultSet.getBigDecimal(columnIndex));
        }
        if (this.isBitType(metaData, columnIndex)) {
            return Optional.of(PostgreSQLInventoryColumnValueReader.getBitObject(resultSet, columnIndex));
        }
        return Optional.empty();
    }

    private boolean isMoneyType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return PG_MONEY_TYPE.equalsIgnoreCase(metaData.getColumnTypeName(columnIndex));
    }

    private boolean isBitType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return -7 == metaData.getColumnType(columnIndex) && PG_BIT_TYPE.equalsIgnoreCase(metaData.getColumnTypeName(columnIndex));
    }

    private static PGobject getBitObject(ResultSet resultSet, int columnIndex) throws SQLException {
        PGobject result = new PGobject();
        result.setType(PG_BIT_TYPE);
        Object bitValue = resultSet.getObject(columnIndex);
        if (null != bitValue) {
            result.setValue((Boolean)bitValue != false ? "1" : "0");
        }
        return result;
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

