/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;

public final class QualifiedDataSourceNode {
    private static final String ROOT_NODE = "nodes";
    private static final String QUALIFIED_DATA_SOURCES = "qualified_data_sources";

    public static String getRootPath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, QUALIFIED_DATA_SOURCES);
    }

    public static String getQualifiedDataSourceNodePath(QualifiedDataSource qualifiedDataSource) {
        return String.join((CharSequence)"/", QualifiedDataSourceNode.getRootPath(), qualifiedDataSource.toString());
    }

    public static Optional<QualifiedDataSource> extractQualifiedDataSource(String qualifiedDataSourcePath) {
        Pattern pattern = Pattern.compile(QualifiedDataSourceNode.getRootPath() + "/(\\S+)$", 2);
        Matcher matcher = pattern.matcher(qualifiedDataSourcePath);
        return matcher.find() ? Optional.of(new QualifiedDataSource(matcher.group(1))) : Optional.empty();
    }

    @Generated
    private QualifiedDataSourceNode() {
    }
}

