/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.version;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.metadata.persist.service.version.MetaDataVersionBasedPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class MetaDataVersionPersistService
implements MetaDataVersionBasedPersistService {
    private final PersistRepository repository;

    @Override
    public void switchActiveVersion(Collection<MetaDataVersion> metaDataVersions) {
        for (MetaDataVersion each : metaDataVersions) {
            if (each.getNextActiveVersion().equals(each.getCurrentActiveVersion())) continue;
            this.repository.persist(each.getActiveVersionNodePath(), each.getNextActiveVersion());
            this.repository.delete(each.getVersionsNodePath());
        }
    }

    @Override
    public String getActiveVersionByFullPath(String fullPath) {
        return this.repository.query(fullPath);
    }

    @Override
    public String getVersionPathByActiveVersion(String path, String activeVersion) {
        return this.repository.query(DatabaseMetaDataNode.getVersionNodeByActiveVersionPath(path, activeVersion));
    }

    @Generated
    public MetaDataVersionPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

