/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.provider;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.constant.ShardingDistSQLConstants;

public final class ShardingRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<ShardingRuleConfiguration> {
    public String convert(ShardingRuleConfiguration ruleConfig) {
        if (ruleConfig.getTables().isEmpty() && ruleConfig.getAutoTables().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        this.appendShardingTableRules(ruleConfig, result);
        if (!ruleConfig.getBindingTableGroups().isEmpty()) {
            result.append(System.lineSeparator()).append(System.lineSeparator());
            this.appendShardingBindingTableRules(ruleConfig, result);
        }
        if (null != ruleConfig.getDefaultDatabaseShardingStrategy() || null != ruleConfig.getDefaultTableShardingStrategy()) {
            result.append(System.lineSeparator()).append(System.lineSeparator());
            this.appendDefaultShardingStrategy(ruleConfig, result);
        }
        return result.toString();
    }

    private void appendShardingTableRules(ShardingRuleConfiguration ruleConfig, StringBuilder stringBuilder) {
        String tableRules = this.getTableRules(ruleConfig);
        String autoTableRules = this.getAutoTableRules(ruleConfig);
        stringBuilder.append("CREATE SHARDING TABLE RULE").append(tableRules);
        if (!Strings.isNullOrEmpty((String)tableRules) && !Strings.isNullOrEmpty((String)autoTableRules)) {
            stringBuilder.append(",");
        }
        stringBuilder.append(autoTableRules).append(";");
    }

    private void appendShardingBindingTableRules(ShardingRuleConfiguration ruleConfig, StringBuilder stringBuilder) {
        stringBuilder.append("CREATE SHARDING TABLE REFERENCE RULE");
        Iterator iterator = ruleConfig.getBindingTableGroups().iterator();
        while (iterator.hasNext()) {
            ShardingTableReferenceRuleConfiguration referenceRuleConfig = (ShardingTableReferenceRuleConfiguration)iterator.next();
            stringBuilder.append(String.format(" %s (%s)", referenceRuleConfig.getName(), referenceRuleConfig.getReference()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(";");
    }

    private void appendDefaultShardingStrategy(ShardingRuleConfiguration ruleConfig, StringBuilder result) {
        if (null != ruleConfig.getDefaultDatabaseShardingStrategy()) {
            this.appendStrategy(ruleConfig.getDefaultDatabaseShardingStrategy(), "CREATE DEFAULT SHARDING DATABASE STRATEGY", result, ruleConfig.getShardingAlgorithms());
            result.append(";");
        }
        if (null != ruleConfig.getDefaultTableShardingStrategy()) {
            if (null != ruleConfig.getDefaultDatabaseShardingStrategy()) {
                result.append(System.lineSeparator()).append(System.lineSeparator());
            }
            this.appendStrategy(ruleConfig.getDefaultTableShardingStrategy(), "CREATE DEFAULT SHARDING TABLE STRATEGY", result, ruleConfig.getShardingAlgorithms());
            result.append(";");
        }
    }

    private String getTableRules(ShardingRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        if (!ruleConfig.getTables().isEmpty()) {
            Iterator iterator = ruleConfig.getTables().iterator();
            while (iterator.hasNext()) {
                ShardingTableRuleConfiguration tableRuleConfig = (ShardingTableRuleConfiguration)iterator.next();
                result.append(String.format(ShardingDistSQLConstants.SHARDING_TABLE, tableRuleConfig.getLogicTable(), tableRuleConfig.getActualDataNodes(), this.appendTableStrategy(tableRuleConfig, ruleConfig)));
                if (!iterator.hasNext()) continue;
                result.append(",");
            }
        }
        return result.toString();
    }

    private String getAutoTableRules(ShardingRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        if (!ruleConfig.getAutoTables().isEmpty()) {
            Iterator iterator = ruleConfig.getAutoTables().iterator();
            while (iterator.hasNext()) {
                ShardingAutoTableRuleConfiguration autoTableRuleConfig = (ShardingAutoTableRuleConfiguration)iterator.next();
                result.append(String.format(ShardingDistSQLConstants.SHARDING_AUTO_TABLE, autoTableRuleConfig.getLogicTable(), autoTableRuleConfig.getActualDataSources(), this.appendAutoTableStrategy(autoTableRuleConfig, ruleConfig)));
                if (!iterator.hasNext()) continue;
                result.append(",");
            }
        }
        return result.toString();
    }

    private String appendTableStrategy(ShardingTableRuleConfiguration tableRuleConfig, ShardingRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        this.appendStrategy(tableRuleConfig.getDatabaseShardingStrategy(), "DATABASE_STRATEGY", result, ruleConfig.getShardingAlgorithms());
        this.appendStrategy(tableRuleConfig.getTableShardingStrategy(), "TABLE_STRATEGY", result, ruleConfig.getShardingAlgorithms());
        this.appendKeyGenerateStrategy(ruleConfig.getKeyGenerators(), tableRuleConfig.getKeyGenerateStrategy(), result);
        this.appendAuditStrategy(ruleConfig.getAuditors(), null != tableRuleConfig.getAuditStrategy() ? tableRuleConfig.getAuditStrategy() : ruleConfig.getDefaultAuditStrategy(), result);
        return result.toString();
    }

    private String appendAutoTableStrategy(ShardingAutoTableRuleConfiguration autoTableRuleConfig, ShardingRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        StandardShardingStrategyConfiguration strategyConfig = (StandardShardingStrategyConfiguration)autoTableRuleConfig.getShardingStrategy();
        String shardingColumn = Strings.isNullOrEmpty((String)strategyConfig.getShardingColumn()) ? ruleConfig.getDefaultShardingColumn() : strategyConfig.getShardingColumn();
        result.append(String.format(ShardingDistSQLConstants.AUTO_TABLE_STRATEGY, shardingColumn, AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)((AlgorithmConfiguration)ruleConfig.getShardingAlgorithms().get(strategyConfig.getShardingAlgorithmName())))));
        this.appendKeyGenerateStrategy(ruleConfig.getKeyGenerators(), autoTableRuleConfig.getKeyGenerateStrategy(), result);
        this.appendAuditStrategy(ruleConfig.getAuditors(), null != autoTableRuleConfig.getAuditStrategy() ? autoTableRuleConfig.getAuditStrategy() : ruleConfig.getDefaultAuditStrategy(), result);
        return result.toString();
    }

    private void appendStrategy(ShardingStrategyConfiguration strategyConfig, String strategyType, StringBuilder stringBuilder, Map<String, AlgorithmConfiguration> shardingAlgorithms) {
        if (null == strategyConfig) {
            return;
        }
        if (Objects.equals(strategyType, "DATABASE_STRATEGY") || Objects.equals(strategyType, "TABLE_STRATEGY")) {
            stringBuilder.append(",").append(System.lineSeparator());
        }
        String type = strategyConfig.getType().toLowerCase();
        String algorithmDefinition = AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)shardingAlgorithms.get(strategyConfig.getShardingAlgorithmName()));
        switch (type) {
            case "standard": {
                StandardShardingStrategyConfiguration standardShardingStrategyConfig = (StandardShardingStrategyConfiguration)strategyConfig;
                stringBuilder.append(String.format("%s(TYPE='%s', SHARDING_COLUMN=%s, SHARDING_ALGORITHM(%s))", strategyType, type, standardShardingStrategyConfig.getShardingColumn(), algorithmDefinition));
                break;
            }
            case "complex": {
                ComplexShardingStrategyConfiguration complexShardingStrategyConfig = (ComplexShardingStrategyConfiguration)strategyConfig;
                stringBuilder.append(String.format("%s(TYPE='%s', SHARDING_COLUMNS=%s, SHARDING_ALGORITHM(%s))", strategyType, type, complexShardingStrategyConfig.getShardingColumns(), algorithmDefinition));
                break;
            }
            case "hint": {
                stringBuilder.append(String.format("%s(TYPE='%s', SHARDING_ALGORITHM(%s))", strategyType, type, algorithmDefinition));
                break;
            }
            case "": {
                stringBuilder.append(String.format("%s(TYPE='%s')", strategyType, "none"));
                break;
            }
        }
    }

    private void appendKeyGenerateStrategy(Map<String, AlgorithmConfiguration> keyGenerators, KeyGenerateStrategyConfiguration keyGenerateStrategyConfig, StringBuilder stringBuilder) {
        if (null == keyGenerateStrategyConfig) {
            return;
        }
        stringBuilder.append(",").append(System.lineSeparator());
        String algorithmDefinition = AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)keyGenerators.get(keyGenerateStrategyConfig.getKeyGeneratorName()));
        stringBuilder.append(String.format("KEY_GENERATE_STRATEGY(COLUMN=%s, %s)", keyGenerateStrategyConfig.getColumn(), algorithmDefinition));
    }

    private void appendAuditStrategy(Map<String, AlgorithmConfiguration> auditors, ShardingAuditStrategyConfiguration auditStrategy, StringBuilder stringBuilder) {
        if (null != auditStrategy) {
            stringBuilder.append(",").append(System.lineSeparator());
            stringBuilder.append(String.format("AUDIT_STRATEGY(%s, ALLOW_HINT_DISABLE=%s)", this.getAlgorithmTypes(auditors, auditStrategy.getAuditorNames()), auditStrategy.isAllowHintDisable()));
        }
    }

    private String getAlgorithmTypes(Map<String, AlgorithmConfiguration> auditors, Collection<String> auditorNames) {
        StringBuilder result = new StringBuilder();
        if (!auditorNames.isEmpty()) {
            Iterator<String> iterator = auditorNames.iterator();
            while (iterator.hasNext()) {
                result.append(AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)auditors.get(iterator.next())));
                if (!iterator.hasNext()) continue;
                result.append(",");
            }
        }
        return result.toString();
    }

    public Class<ShardingRuleConfiguration> getType() {
        return ShardingRuleConfiguration.class;
    }
}

