/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shardingsphere.shade.io.opentelemetry.api.OpenTelemetry;
import org.apache.shardingsphere.shade.io.opentelemetry.api.logs.LoggerBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.logs.LoggerProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.Tracer;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.TracerBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.TracerProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.context.propagation.ContextPropagators;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkLoggerProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.SdkTracerProvider;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(OpenTelemetrySdk.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final ObfuscatedTracerProvider tracerProvider;
    private final ObfuscatedMeterProvider meterProvider;
    private final ObfuscatedLoggerProvider loggerProvider;
    private final ContextPropagators propagators;

    OpenTelemetrySdk(SdkTracerProvider tracerProvider, SdkMeterProvider meterProvider, SdkLoggerProvider loggerProvider, ContextPropagators propagators) {
        this.tracerProvider = new ObfuscatedTracerProvider(tracerProvider);
        this.meterProvider = new ObfuscatedMeterProvider(meterProvider);
        this.loggerProvider = new ObfuscatedLoggerProvider(loggerProvider);
        this.propagators = propagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    @Override
    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public SdkTracerProvider getSdkTracerProvider() {
        return this.tracerProvider.unobfuscate();
    }

    @Override
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public SdkMeterProvider getSdkMeterProvider() {
        return this.meterProvider.unobfuscate();
    }

    @Override
    public LoggerProvider getLogsBridge() {
        return this.loggerProvider;
    }

    public SdkLoggerProvider getSdkLoggerProvider() {
        return this.loggerProvider.unobfuscate();
    }

    @Override
    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            LOGGER.info("Multiple shutdown calls");
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        results.add(this.tracerProvider.unobfuscate().shutdown());
        results.add(this.meterProvider.unobfuscate().shutdown());
        results.add(this.loggerProvider.unobfuscate().shutdown());
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "OpenTelemetrySdk{tracerProvider=" + this.tracerProvider.unobfuscate() + ", meterProvider=" + this.meterProvider.unobfuscate() + ", loggerProvider=" + this.loggerProvider.unobfuscate() + ", propagators=" + this.propagators + "}";
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Tracer get(String instrumentationScopeName) {
            return this.delegate.get(instrumentationScopeName);
        }

        @Override
        public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
            return this.delegate.get(instrumentationScopeName, instrumentationScopeVersion);
        }

        @Override
        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedMeterProvider
    implements MeterProvider {
        private final SdkMeterProvider delegate;

        ObfuscatedMeterProvider(SdkMeterProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public MeterBuilder meterBuilder(String instrumentationScopeName) {
            return this.delegate.meterBuilder(instrumentationScopeName);
        }

        public SdkMeterProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedLoggerProvider
    implements LoggerProvider {
        private final SdkLoggerProvider delegate;

        ObfuscatedLoggerProvider(SdkLoggerProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public LoggerBuilder loggerBuilder(String instrumentationScopeName) {
            return this.delegate.loggerBuilder(instrumentationScopeName);
        }

        public SdkLoggerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

