/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.standalone.jdbc.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.directory.ClasspathResourceDirectoryReader;
import org.apache.shardingsphere.mode.repository.standalone.jdbc.sql.JDBCRepositorySQL;

public final class JDBCRepositorySQLLoader {
    private static final String ROOT_DIRECTORY = "sql";
    private static final String FILE_EXTENSION = ".xml";
    private static final ObjectMapper XML_MAPPER = XmlMapper.builder().build();

    public static JDBCRepositorySQL load(String type) {
        JDBCRepositorySQL result = null;
        try (Stream resourceNameStream = ClasspathResourceDirectoryReader.read((ClassLoader)JDBCRepositorySQLLoader.class.getClassLoader(), (String)ROOT_DIRECTORY);){
            Iterable resourceNameIterable = resourceNameStream::iterator;
            for (String each : resourceNameIterable) {
                if (!each.endsWith(FILE_EXTENSION)) continue;
                JDBCRepositorySQL provider = (JDBCRepositorySQL)XML_MAPPER.readValue(JDBCRepositorySQLLoader.class.getClassLoader().getResourceAsStream(each), JDBCRepositorySQL.class);
                if (provider.isDefault()) {
                    result = provider;
                }
                if (!Objects.equals(provider.getType(), type)) continue;
                result = provider;
                break;
            }
        }
        return result;
    }

    @Generated
    private JDBCRepositorySQLLoader() {
    }
}

