/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.dml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WithAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class UpdateStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
WhereAvailable,
WithAvailable {
    private final TablesContext tablesContext;
    private final Collection<WhereSegment> whereSegments = new LinkedList<WhereSegment>();
    private final Collection<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
    private final Collection<BinaryOperationExpression> joinConditions = new LinkedList<BinaryOperationExpression>();

    public UpdateStatementContext(UpdateStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(this.getAllSimpleTableSegments());
        this.getSqlStatement().getWhere().ifPresent(this.whereSegments::add);
        ColumnExtractor.extractColumnSegments(this.columnSegments, this.whereSegments);
        ExpressionExtractor.extractJoinConditions(this.joinConditions, this.whereSegments);
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromUpdate(this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    public UpdateStatement getSqlStatement() {
        return (UpdateStatement)super.getSqlStatement();
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Override
    public Optional<WithSegment> getWith() {
        return this.getSqlStatement().getWithSegment();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Override
    @Generated
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.joinConditions;
    }
}

