/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.context;

import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptConditionEngine;
import org.apache.shardingsphere.encrypt.rewrite.parameter.EncryptParameterRewritersRegistry;
import org.apache.shardingsphere.encrypt.rewrite.token.EncryptTokenGenerateBuilder;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewritersBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewritersRegistry;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class EncryptSQLRewriteContextDecorator
implements SQLRewriteContextDecorator<EncryptRule> {
    public void decorate(EncryptRule rule, ConfigurationProperties props, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        SQLStatementContext sqlStatementContext = sqlRewriteContext.getSqlStatementContext();
        if (!this.containsEncryptTable(rule, sqlStatementContext)) {
            return;
        }
        Collection<EncryptCondition> encryptConditions = this.createEncryptConditions(rule, sqlRewriteContext);
        if (!sqlRewriteContext.getParameters().isEmpty()) {
            Collection parameterRewriters = new ParameterRewritersBuilder(sqlStatementContext).build((ParameterRewritersRegistry)new EncryptParameterRewritersRegistry(rule, sqlRewriteContext.getDatabase().getName(), encryptConditions));
            this.rewriteParameters(sqlRewriteContext, parameterRewriters);
        }
        EncryptTokenGenerateBuilder sqlTokenGeneratorBuilder = new EncryptTokenGenerateBuilder(rule, sqlStatementContext, encryptConditions, sqlRewriteContext.getDatabase());
        sqlRewriteContext.addSQLTokenGenerators(sqlTokenGeneratorBuilder.getSQLTokenGenerators());
    }

    private boolean containsEncryptTable(EncryptRule rule, SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof TableAvailable)) {
            return false;
        }
        for (SimpleTableSegment each : ((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables()) {
            if (!rule.findEncryptTable(each.getTableName().getIdentifier().getValue()).isPresent()) continue;
            return true;
        }
        return false;
    }

    private Collection<EncryptCondition> createEncryptConditions(EncryptRule rule, SQLRewriteContext sqlRewriteContext) {
        SQLStatementContext sqlStatementContext = sqlRewriteContext.getSqlStatementContext();
        if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext() && !((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext().getWhereSegments().isEmpty()) {
            return this.createEncryptConditions(rule, sqlRewriteContext, (SQLStatementContext)((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext());
        }
        return this.createEncryptConditions(rule, sqlRewriteContext, sqlStatementContext);
    }

    private Collection<EncryptCondition> createEncryptConditions(EncryptRule rule, SQLRewriteContext sqlRewriteContext, SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        Collection allSubqueryContexts = SQLStatementContextExtractor.getAllSubqueryContexts((SQLStatementContext)sqlStatementContext);
        Collection whereSegments = SQLStatementContextExtractor.getWhereSegments((WhereAvailable)((WhereAvailable)sqlStatementContext), (Collection)allSubqueryContexts);
        return new EncryptConditionEngine(rule, sqlRewriteContext.getDatabase()).createEncryptConditions(whereSegments);
    }

    private void rewriteParameters(SQLRewriteContext sqlRewriteContext, Collection<ParameterRewriter> parameterRewriters) {
        for (ParameterRewriter each : parameterRewriters) {
            each.rewrite(sqlRewriteContext.getParameterBuilder(), sqlRewriteContext.getSqlStatementContext(), sqlRewriteContext.getParameters());
        }
    }

    public int getOrder() {
        return 10;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

