/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.yaml.swapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.yaml.config.YamlMaskRuleConfiguration;
import org.apache.shardingsphere.mask.yaml.config.rule.YamlMaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.yaml.swapper.rule.YamlMaskTableRuleConfigurationSwapper;

public final class YamlMaskRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlMaskRuleConfiguration, MaskRuleConfiguration> {
    private final YamlMaskTableRuleConfigurationSwapper tableSwapper = new YamlMaskTableRuleConfigurationSwapper();
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();

    public YamlMaskRuleConfiguration swapToYamlConfiguration(MaskRuleConfiguration data) {
        YamlMaskRuleConfiguration result = new YamlMaskRuleConfiguration();
        data.getTables().forEach(each -> result.getTables().put(each.getName(), this.tableSwapper.swapToYamlConfiguration((MaskTableRuleConfiguration)each)));
        data.getMaskAlgorithms().forEach((key, value) -> result.getMaskAlgorithms().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        return result;
    }

    public MaskRuleConfiguration swapToObject(YamlMaskRuleConfiguration yamlConfig) {
        return new MaskRuleConfiguration(this.swapTables(yamlConfig), this.swapMaskAlgorithm(yamlConfig));
    }

    private Collection<MaskTableRuleConfiguration> swapTables(YamlMaskRuleConfiguration yamlConfig) {
        LinkedList<MaskTableRuleConfiguration> result = new LinkedList<MaskTableRuleConfiguration>();
        for (Map.Entry<String, YamlMaskTableRuleConfiguration> entry : yamlConfig.getTables().entrySet()) {
            YamlMaskTableRuleConfiguration yamlMaskTableRuleConfig = entry.getValue();
            yamlMaskTableRuleConfig.setName(entry.getKey());
            result.add(this.tableSwapper.swapToObject(yamlMaskTableRuleConfig));
        }
        return result;
    }

    private Map<String, AlgorithmConfiguration> swapMaskAlgorithm(YamlMaskRuleConfiguration yamlConfig) {
        LinkedHashMap<String, AlgorithmConfiguration> result = new LinkedHashMap<String, AlgorithmConfiguration>(yamlConfig.getMaskAlgorithms().size(), 1.0f);
        for (Map.Entry<String, YamlAlgorithmConfiguration> entry : yamlConfig.getMaskAlgorithms().entrySet()) {
            result.put(entry.getKey(), this.algorithmSwapper.swapToObject(entry.getValue()));
        }
        return result;
    }

    public Class<MaskRuleConfiguration> getTypeClass() {
        return MaskRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "MASK";
    }

    public int getOrder() {
        return 30;
    }
}

