/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.election;

import java.util.Objects;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.internal.election.LeaderNode;
import org.apache.shardingsphere.elasticjob.lite.internal.election.LeaderService;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerNode;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerStatus;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class ElectionListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final LeaderNode leaderNode;
    private final ServerNode serverNode;
    private final LeaderService leaderService;
    private final ServerService serverService;

    public ElectionListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.leaderNode = new LeaderNode(jobName);
        this.serverNode = new ServerNode(jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new LeaderElectionJobListener());
        this.addDataListener(new LeaderAbdicationJobListener());
    }

    class LeaderAbdicationJobListener
    implements DataChangedEventListener {
        LeaderAbdicationJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (ElectionListenerManager.this.leaderService.isLeader() && this.isLocalServerDisabled(event.getKey(), event.getValue())) {
                ElectionListenerManager.this.leaderService.removeLeader();
            }
        }

        private boolean isLocalServerDisabled(String path, String data) {
            return ElectionListenerManager.this.serverNode.isLocalServerPath(path) && ServerStatus.DISABLED.name().equals(data);
        }
    }

    class LeaderElectionJobListener
    implements DataChangedEventListener {
        LeaderElectionJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (!JobRegistry.getInstance().isShutdown(ElectionListenerManager.this.jobName) && (this.isActiveElection(event.getKey(), event.getValue()) || this.isPassiveElection(event.getKey(), event.getType()))) {
                ElectionListenerManager.this.leaderService.electLeader();
            }
        }

        private boolean isActiveElection(String path, String data) {
            return !ElectionListenerManager.this.leaderService.hasLeader() && this.isLocalServerEnabled(path, data);
        }

        private boolean isPassiveElection(String path, DataChangedEvent.Type eventType) {
            JobInstance jobInstance = JobRegistry.getInstance().getJobInstance(ElectionListenerManager.this.jobName);
            return !Objects.isNull(jobInstance) && this.isLeaderCrashed(path, eventType) && ElectionListenerManager.this.serverService.isAvailableServer(jobInstance.getServerIp());
        }

        private boolean isLeaderCrashed(String path, DataChangedEvent.Type eventType) {
            return ElectionListenerManager.this.leaderNode.isLeaderInstancePath(path) && DataChangedEvent.Type.DELETED == eventType;
        }

        private boolean isLocalServerEnabled(String path, String data) {
            return ElectionListenerManager.this.serverNode.isLocalServerPath(path) && !ServerStatus.DISABLED.name().equals(data);
        }
    }
}

