/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.handler.converter;

import com.google.common.base.Joiner;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;

public final class SingleRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<SingleRuleConfiguration> {
    public String convert(SingleRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        if (!ruleConfig.getTables().isEmpty()) {
            result.append(this.convertLoadTable(ruleConfig));
        }
        if (ruleConfig.getDefaultDataSource().isPresent()) {
            if (!ruleConfig.getTables().isEmpty()) {
                result.append(System.lineSeparator()).append(System.lineSeparator());
            }
            result.append(this.convertSetDefaultSingleTableStorageUnit((String)ruleConfig.getDefaultDataSource().get()));
        }
        return result.toString();
    }

    private String convertLoadTable(SingleRuleConfiguration ruleConfig) {
        return String.format("LOAD SINGLE TABLE %s;", Joiner.on((String)",").join((Iterable)ruleConfig.getTables()));
    }

    private String convertSetDefaultSingleTableStorageUnit(String defaultStorageUnitName) {
        return String.format("SET DEFAULT SINGLE TABLE STORAGE UNIT = %s;", defaultStorageUnitName);
    }

    public Class<SingleRuleConfiguration> getType() {
        return SingleRuleConfiguration.class;
    }
}

