/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;

public final class MySQLSequenceIdInboundHandler
extends ChannelInboundHandlerAdapter {
    public MySQLSequenceIdInboundHandler(Channel channel) {
        channel.attr(MySQLConstants.SEQUENCE_ID_ATTRIBUTE_KEY).set((Object)new AtomicInteger());
    }

    public void channelRead(ChannelHandlerContext context, Object msg) {
        ByteBuf byteBuf = (ByteBuf)msg;
        short sequenceId = byteBuf.readUnsignedByte();
        ((AtomicInteger)context.channel().attr(MySQLConstants.SEQUENCE_ID_ATTRIBUTE_KEY).get()).set(sequenceId + 1);
        context.fireChannelRead((Object)byteBuf.readSlice(byteBuf.readableBytes()));
    }
}

