/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.view;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterViewStatement;

public final class AlterViewStatementSchemaRefresher
implements MetaDataRefresher<AlterViewStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, AlterViewStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Optional viewDefinition;
        String viewName = TableRefreshUtils.getTableName(databaseType, sqlStatement.getView().getTableName().getIdentifier());
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName, logicDataSourceNames);
        Optional renameView = sqlStatement.getRenameView();
        if (renameView.isPresent()) {
            String renameViewName = ((SimpleTableSegment)renameView.get()).getTableName().getIdentifier().getValue();
            String originalView = database.getSchema(schemaName).getView(viewName).getViewDefinition();
            ShardingSphereSchema schema = this.getSchema(database, logicDataSourceNames, schemaName, renameViewName, originalView, props);
            alterSchemaMetaDataPOJO.getAlteredTables().add(schema.getTable(renameViewName));
            alterSchemaMetaDataPOJO.getAlteredViews().add(schema.getView(renameViewName));
            alterSchemaMetaDataPOJO.getDroppedTables().add(viewName);
            alterSchemaMetaDataPOJO.getDroppedViews().add(viewName);
        }
        if ((viewDefinition = sqlStatement.getViewDefinition()).isPresent()) {
            ShardingSphereSchema schema = this.getSchema(database, logicDataSourceNames, schemaName, viewName, (String)viewDefinition.get(), props);
            alterSchemaMetaDataPOJO.getAlteredTables().add(schema.getTable(viewName));
            alterSchemaMetaDataPOJO.getAlteredViews().add(schema.getView(viewName));
        }
        metaDataManagerPersistService.alterSchemaMetaData(alterSchemaMetaDataPOJO);
    }

    private ShardingSphereSchema getSchema(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, String viewName, String viewDefinition, ConfigurationProperties props) throws SQLException {
        RuleMetaData ruleMetaData = new RuleMetaData(new LinkedList(database.getRuleMetaData().getRules()));
        if (TableRefreshUtils.isSingleTable(viewName, database)) {
            ruleMetaData.getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.put((String)logicDataSourceNames.iterator().next(), schemaName, viewName));
        }
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getResourceMetaData().getStorageUnits(), ruleMetaData.getRules(), props, schemaName);
        Map schemas = GenericSchemaBuilder.build(Collections.singletonList(viewName), (DatabaseType)database.getProtocolType(), (GenericSchemaBuilderMaterial)material);
        Optional<ShardingSphereTable> actualViewMetaData = Optional.ofNullable((ShardingSphereSchema)schemas.get(schemaName)).map(optional -> optional.getTable(viewName));
        ShardingSphereSchema result = new ShardingSphereSchema(schemaName);
        actualViewMetaData.ifPresent(arg_0 -> ((ShardingSphereSchema)result).putTable(arg_0));
        result.putView(new ShardingSphereView(viewName, viewDefinition));
        return result;
    }

    @Override
    public Class<AlterViewStatement> getType() {
        return AlterViewStatement.class;
    }
}

