/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.api;

import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.database.cache.ParseTreeCacheBuilder;
import org.apache.shardingsphere.sql.parser.core.database.parser.SQLParserExecutor;

public final class SQLParserEngine {
    private final SQLParserExecutor sqlParserExecutor;
    private final LoadingCache<String, ParseASTNode> parseTreeCache;

    public SQLParserEngine(DatabaseType databaseType, CacheOption cacheOption) {
        this.sqlParserExecutor = new SQLParserExecutor(databaseType);
        this.parseTreeCache = ParseTreeCacheBuilder.build(cacheOption, databaseType);
    }

    public SQLParserEngine(String databaseType, CacheOption cacheOption) {
        this((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)databaseType), cacheOption);
    }

    public ParseASTNode parse(String sql, boolean useCache) {
        return useCache ? (ParseASTNode)this.parseTreeCache.get((Object)sql) : this.sqlParserExecutor.parse(sql);
    }
}

