/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.checker.dml;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.exception.algorithm.DuplicateInsertDataRecordException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedUpdatingShardingValueException;
import org.apache.shardingsphere.sharding.route.engine.checker.ShardingRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.util.ShardingRouteContextCheckUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;

public final class ShardingInsertRouteContextChecker
implements ShardingRouteContextChecker {
    private final ShardingConditions shardingConditions;

    @Override
    public void check(ShardingRule shardingRule, QueryContext queryContext, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        Collection assignments;
        Optional<ShardingConditions> onDuplicateKeyShardingConditions;
        Optional<RouteContext> onDuplicateKeyRouteContext;
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        InsertStatement insertStatement = (InsertStatement)sqlStatementContext.getSqlStatement();
        Optional insertSelect = insertStatement.getInsertSelect();
        String tableName = insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        if (insertSelect.isPresent() && this.shardingConditions.isNeedMerge()) {
            boolean singleRoutingOrSameShardingCondition = routeContext.isSingleRouting() || this.shardingConditions.isSameShardingCondition();
            ShardingSpherePreconditions.checkState((boolean)singleRoutingOrSameShardingCondition, () -> new UnsupportedShardingOperationException("INSERT ... SELECT ...", tableName));
        }
        if ((onDuplicateKeyRouteContext = (onDuplicateKeyShardingConditions = ShardingRouteContextCheckUtils.createShardingConditions(sqlStatementContext, shardingRule, assignments = (Collection)insertStatement.getOnDuplicateKeyColumns().map(OnDuplicateKeyColumnsSegment::getColumns).orElse(Collections.emptyList()), queryContext.getParameters())).map(optional -> new ShardingStandardRouteEngine(tableName, (ShardingConditions)optional, sqlStatementContext, queryContext.getHintValueContext(), props).route(shardingRule))).isPresent() && !ShardingRouteContextCheckUtils.isSameRouteContext(routeContext, onDuplicateKeyRouteContext.get())) {
            throw new UnsupportedUpdatingShardingValueException(tableName);
        }
        if (!routeContext.isSingleRouting()) {
            boolean isSingleDataNode = routeContext.getOriginalDataNodes().stream().allMatch(dataNodes -> 1 == dataNodes.size());
            ShardingSpherePreconditions.checkState((boolean)isSingleDataNode, () -> new DuplicateInsertDataRecordException(this.shardingConditions, tableName));
        }
    }

    @Generated
    public ShardingInsertRouteContextChecker(ShardingConditions shardingConditions) {
        this.shardingConditions = shardingConditions;
    }
}

