/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.distsql.handler.update;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskColumnRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.distsql.statement.DropMaskRuleStatement;
import org.apache.shardingsphere.mask.rule.MaskRule;

@DistSQLExecutorCurrentRuleRequired(value=MaskRule.class)
public final class DropMaskRuleExecutor
implements DatabaseRuleDropExecutor<DropMaskRuleStatement, MaskRule, MaskRuleConfiguration> {
    private ShardingSphereDatabase database;
    private MaskRule rule;

    public void checkBeforeUpdate(DropMaskRuleStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkToBeDroppedMaskTableNames(sqlStatement);
        }
    }

    private void checkToBeDroppedMaskTableNames(DropMaskRuleStatement sqlStatement) {
        Collection currentMaskTableNames = (Collection)this.rule.getConfiguration().getTables().stream().map(MaskTableRuleConfiguration::getName).collect(Collectors.toCollection(CaseInsensitiveSet::new));
        Collection notExistedTableNames = sqlStatement.getTables().stream().filter(each -> !currentMaskTableNames.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedTableNames, () -> new MissingRequiredRuleException("Mask", this.database.getName(), notExistedTableNames));
    }

    public boolean hasAnyOneToBeDropped(DropMaskRuleStatement sqlStatement) {
        return !Collections.disjoint((Collection)this.rule.getConfiguration().getTables().stream().map(MaskTableRuleConfiguration::getName).collect(Collectors.toCollection(CaseInsensitiveSet::new)), sqlStatement.getTables());
    }

    public MaskRuleConfiguration buildToBeDroppedRuleConfiguration(DropMaskRuleStatement sqlStatement) {
        LinkedList<MaskTableRuleConfiguration> toBeDroppedTables = new LinkedList<MaskTableRuleConfiguration>();
        for (String each2 : sqlStatement.getTables()) {
            toBeDroppedTables.add(new MaskTableRuleConfiguration(each2, Collections.emptyList()));
            this.dropRule(each2);
        }
        LinkedHashMap toBeDroppedAlgorithms = new LinkedHashMap();
        this.findUnusedAlgorithms(this.rule.getConfiguration()).forEach(each -> toBeDroppedAlgorithms.put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getMaskAlgorithms().get(each)));
        return new MaskRuleConfiguration(toBeDroppedTables, toBeDroppedAlgorithms);
    }

    private void dropRule(String ruleName) {
        Optional<MaskTableRuleConfiguration> maskTableRuleConfig = this.rule.getConfiguration().getTables().stream().filter(each -> each.getName().equalsIgnoreCase(ruleName)).findAny();
        maskTableRuleConfig.ifPresent(optional -> this.rule.getConfiguration().getTables().remove(maskTableRuleConfig.get()));
    }

    private Collection<String> findUnusedAlgorithms(MaskRuleConfiguration currentRuleConfig) {
        Collection inUsedAlgorithms = currentRuleConfig.getTables().stream().flatMap(each -> each.getColumns().stream()).map(MaskColumnRuleConfiguration::getMaskAlgorithm).collect(Collectors.toSet());
        return currentRuleConfig.getMaskAlgorithms().keySet().stream().filter(each -> !inUsedAlgorithms.contains(each)).collect(Collectors.toSet());
    }

    public Class<MaskRule> getRuleClass() {
        return MaskRule.class;
    }

    public Class<DropMaskRuleStatement> getType() {
        return DropMaskRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(MaskRule rule) {
        this.rule = rule;
    }
}

